/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.policy.AttributeDesignatorType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ResourceAttributeDesignatorTest
extends XMLObjectProviderBaseTestCase {
    private String expectedDataType;
    private String expectedAttributeId;
    private String optionalIssuer;
    private Boolean optionalMustBePresent;

    public ResourceAttributeDesignatorTest() {
        this.singleElementFile = "/data/org/opensaml/xacml/policy/impl/ResourceAttributeDesignator.xml";
        this.singleElementOptionalAttributesFile = "/data/org/opensaml/xacml/policy/impl/ResourceAttributeDesignatorOptionalAttributes.xml";
        this.expectedDataType = "https://example.org/Data/Type/Resource";
        this.expectedAttributeId = "https://example.org/Attribute/Id/Resource";
        this.optionalIssuer = "TheIssuerResource";
        this.optionalMustBePresent = true;
    }

    @Test
    public void testSingleElementUnmarshall() {
        AttributeDesignatorType attributeDesignator = (AttributeDesignatorType)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)attributeDesignator.getDataType(), (String)this.expectedDataType);
        Assert.assertEquals((String)attributeDesignator.getAttributeId(), (String)this.expectedAttributeId);
    }

    @Test
    public void testSingleElementMarshall() {
        AttributeDesignatorType attributeDesignator = (AttributeDesignatorType)this.buildXMLObject(AttributeDesignatorType.RESOURCE_ATTRIBUTE_DESIGNATOR_ELEMENT_NAME);
        attributeDesignator.setDataType(this.expectedDataType);
        attributeDesignator.setAttributeId(this.expectedAttributeId);
        attributeDesignator.setMustBePresent(null);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)attributeDesignator);
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        AttributeDesignatorType attributeDesignator = (AttributeDesignatorType)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)attributeDesignator.getDataType(), (String)this.expectedDataType);
        Assert.assertEquals((String)attributeDesignator.getAttributeId(), (String)this.expectedAttributeId);
        Assert.assertEquals((Object)attributeDesignator.getMustBePresent(), (Object)this.optionalMustBePresent);
        Assert.assertEquals((String)attributeDesignator.getIssuer(), (String)this.optionalIssuer);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        AttributeDesignatorType attributeDesignator = (AttributeDesignatorType)this.buildXMLObject(AttributeDesignatorType.RESOURCE_ATTRIBUTE_DESIGNATOR_ELEMENT_NAME);
        attributeDesignator.setDataType(this.expectedDataType);
        attributeDesignator.setAttributeId(this.expectedAttributeId);
        attributeDesignator.setMustBePresent(this.optionalMustBePresent);
        attributeDesignator.setIssuer(this.optionalIssuer);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)attributeDesignator);
    }
}

