/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.policy.SubjectMatchType;
import org.opensaml.xacml.policy.SubjectType;
import org.opensaml.xacml.policy.impl.SubjectMatchTypeImplBuilder;
import org.opensaml.xacml.policy.impl.SubjectTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SubjectTest
extends XMLObjectProviderBaseTestCase {
    private String expectedMatchId;
    private int expectedResourceMatches;

    public SubjectTest() {
        this.singleElementFile = "/data/org/opensaml/xacml/policy/impl/Subject.xml";
        this.childElementsFile = "/data/org/opensaml/xacml/policy/impl/SubjectChildElements.xml";
        this.expectedMatchId = "http://example.org/Subject/Match/Id";
        this.expectedResourceMatches = 2;
    }

    @Test
    public void testSingleElementUnmarshall() {
        SubjectType subject = (SubjectType)this.unmarshallElement(this.singleElementFile);
        Assert.assertTrue((boolean)subject.getSubjectMatches().isEmpty());
    }

    @Test
    public void testSingleElementMarshall() {
        SubjectType subject = new SubjectTypeImplBuilder().buildObject();
        this.assertXMLEquals(this.expectedDOM, (XMLObject)subject);
    }

    @Test
    public void testChildElementsUnmarshall() {
        SubjectType subject = (SubjectType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)subject.getSubjectMatches().size(), (int)this.expectedResourceMatches);
        for (SubjectMatchType subjectMatch : subject.getSubjectMatches()) {
            Assert.assertEquals((String)subjectMatch.getMatchId(), (String)this.expectedMatchId);
        }
    }

    @Test
    public void testChildElementsMarshall() {
        SubjectType subject = new SubjectTypeImplBuilder().buildObject();
        SubjectMatchTypeImplBuilder builder = new SubjectMatchTypeImplBuilder();
        for (int i = 0; i < this.expectedResourceMatches; ++i) {
            SubjectMatchType subjectMatch = builder.buildObject();
            subjectMatch.setMatchId(this.expectedMatchId);
            subject.getSubjectMatches().add(subjectMatch);
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)subject);
    }
}

