/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.ctx.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.ctx.AttributeValueType;
import org.opensaml.xacml.ctx.impl.AttributeValueTypeImplBuilder;
import org.opensaml.xacml.policy.ActionType;
import org.opensaml.xacml.policy.ApplyType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AttributeValueTest
extends XMLObjectProviderBaseTestCase {
    private String expectedFunctionId;
    private String expectedTextContent;
    private QName[] expectedAttributeName = new QName[]{new QName("foo"), new QName("urn:oasis:names:tc:xacml:2.0:policy:schema:os", "bar", "xacml")};
    private String[] expectedAttributeValue = new String[]{"bar", "foo"};

    public AttributeValueTest() {
        this.singleElementFile = "/data/org/opensaml/xacml/ctx/impl/AttributeValue.xml";
        this.singleElementOptionalAttributesFile = "/data/org/opensaml/xacml/ctx/impl/AttributeValueOptionalAttributes.xml";
        this.childElementsFile = "/data/org/opensaml/xacml/ctx/impl/AttributeValueChildElements.xml";
        this.expectedFunctionId = "http://example.org";
        this.expectedTextContent = "AttributeValueText";
    }

    @Test
    public void testSingleElementUnmarshall() {
        AttributeValueType attributeValue = (AttributeValueType)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)attributeValue.getValue(), (String)this.expectedTextContent);
        Assert.assertTrue((boolean)attributeValue.getUnknownAttributes().isEmpty());
        Assert.assertTrue((boolean)attributeValue.getUnknownXMLObjects().isEmpty());
    }

    @Test
    public void testSingleElementMarshall() {
        AttributeValueType attributeValue = new AttributeValueTypeImplBuilder().buildObject();
        attributeValue.setValue(this.expectedTextContent);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)attributeValue);
    }

    @Test
    public void testChildElementsUnmarshall() {
        AttributeValueType attributeValue = (AttributeValueType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)attributeValue.getUnknownXMLObjects().size(), (int)2);
        Assert.assertNotNull((Object)attributeValue.getUnknownXMLObjects(ActionType.DEFAULT_ELEMENT_NAME));
        Assert.assertEquals((String)((ApplyType)attributeValue.getUnknownXMLObjects(ApplyType.DEFAULT_ELEMENT_NAME).get(0)).getFunctionId(), (String)this.expectedFunctionId);
    }

    @Test
    public void testChildElementsMarshall() {
        AttributeValueType attributeValue = new AttributeValueTypeImplBuilder().buildObject();
        attributeValue.getUnknownXMLObjects().add(this.buildXMLObject(ActionType.DEFAULT_ELEMENT_NAME));
        ApplyType apply = (ApplyType)this.buildXMLObject(ApplyType.DEFAULT_ELEMENT_NAME);
        apply.setFunctionId(this.expectedFunctionId);
        attributeValue.getUnknownXMLObjects().add(apply);
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)attributeValue);
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        AttributeValueType attributeValue = (AttributeValueType)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((int)attributeValue.getUnknownAttributes().size(), (int)this.expectedAttributeValue.length);
        for (int i = 0; i < this.expectedAttributeValue.length; ++i) {
            Assert.assertEquals((String)attributeValue.getUnknownAttributes().get((Object)this.expectedAttributeName[i]), (String)this.expectedAttributeValue[i]);
        }
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        AttributeValueType attributeValue = new AttributeValueTypeImplBuilder().buildObject();
        for (int i = 0; i < this.expectedAttributeValue.length; ++i) {
            attributeValue.getUnknownAttributes().put(this.expectedAttributeName[i], this.expectedAttributeValue[i]);
        }
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)attributeValue);
    }
}

