/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.ctx.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.ctx.ActionType;
import org.opensaml.xacml.ctx.EnvironmentType;
import org.opensaml.xacml.ctx.RequestType;
import org.opensaml.xacml.ctx.ResourceType;
import org.opensaml.xacml.ctx.SubjectType;
import org.opensaml.xacml.ctx.impl.RequestTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RequestTest
extends XMLObjectProviderBaseTestCase {
    private int expectedNumSubjects;
    private int expectedNumResources;
    private String expectedSubjectCategory;

    public RequestTest() {
        this.singleElementFile = "/data/org/opensaml/xacml/ctx/impl/Request.xml";
        this.childElementsFile = "/data/org/opensaml/xacml/ctx/impl/RequestChildElements.xml";
        this.expectedNumSubjects = 3;
        this.expectedNumResources = 2;
        this.expectedSubjectCategory = "https://example.org/Request/Subject/Subject/Category";
    }

    @Test
    public void testSingleElementUnmarshall() {
        RequestType request = (RequestType)this.unmarshallElement(this.singleElementFile);
        Assert.assertTrue((boolean)request.getSubjects().isEmpty());
        Assert.assertTrue((boolean)request.getResources().isEmpty());
        Assert.assertNull((Object)request.getAction());
        Assert.assertNull((Object)request.getEnvironment());
    }

    @Test
    public void testSingleElementMarshall() {
        RequestType request = new RequestTypeImplBuilder().buildObject();
        this.assertXMLEquals(this.expectedDOM, (XMLObject)request);
    }

    @Test
    public void testChildElementsUnmarshall() {
        RequestType request = (RequestType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)request.getSubjects().size(), (int)this.expectedNumSubjects);
        for (SubjectType subject : request.getSubjects()) {
            Assert.assertEquals((String)subject.getSubjectCategory(), (String)this.expectedSubjectCategory);
        }
        Assert.assertEquals((int)request.getResources().size(), (int)this.expectedNumResources);
        Assert.assertNotNull((Object)request.getAction());
        Assert.assertNotNull((Object)request.getEnvironment());
    }

    @Test
    public void testChildElementsMarshall() {
        int i;
        RequestType request = new RequestTypeImplBuilder().buildObject();
        for (i = 0; i < this.expectedNumResources; ++i) {
            request.getResources().add((ResourceType)this.buildXMLObject(ResourceType.DEFAULT_ELEMENT_NAME));
        }
        for (i = 0; i < this.expectedNumSubjects; ++i) {
            SubjectType subject = (SubjectType)this.buildXMLObject(SubjectType.DEFAULT_ELEMENT_NAME);
            subject.setSubjectCategory(this.expectedSubjectCategory);
            request.getSubjects().add(subject);
        }
        request.setAction((ActionType)this.buildXMLObject(ActionType.DEFAULT_ELEMENT_NAME));
        request.setEnvironment((EnvironmentType)this.buildXMLObject(EnvironmentType.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)request);
    }
}

