/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.ctx.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.ctx.DecisionType;
import org.opensaml.xacml.ctx.ResultType;
import org.opensaml.xacml.ctx.StatusType;
import org.opensaml.xacml.ctx.impl.ResultTypeImplBuilder;
import org.opensaml.xacml.policy.ObligationsType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ResultTest
extends XMLObjectProviderBaseTestCase {
    private DecisionType.DECISION expectedDecision;

    public ResultTest() {
        this.singleElementFile = "/data/org/opensaml/xacml/ctx/impl/Result.xml";
        this.childElementsFile = "/data/org/opensaml/xacml/ctx/impl/ResultChildElements.xml";
        this.expectedDecision = DecisionType.DECISION.NotApplicable;
    }

    @Test
    public void testSingleElementUnmarshall() {
        ResultType result = (ResultType)this.unmarshallElement(this.singleElementFile);
        Assert.assertNull((Object)result.getDecision());
        Assert.assertNull((Object)result.getStatus());
        Assert.assertNull((Object)result.getObligations());
    }

    @Test
    public void testSingleElementMarshall() {
        ResultType result = new ResultTypeImplBuilder().buildObject();
        this.assertXMLEquals(this.expectedDOM, (XMLObject)result);
    }

    @Test
    public void testChildElementsUnmarshall() {
        ResultType result = (ResultType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((Object)result.getDecision().getDecision(), (Object)this.expectedDecision);
        Assert.assertNotNull((Object)result.getStatus());
        Assert.assertNotNull((Object)result.getObligations());
    }

    @Test
    public void testChildElementsMarshall() {
        ResultType result = new ResultTypeImplBuilder().buildObject();
        DecisionType decision = (DecisionType)this.buildXMLObject(DecisionType.DEFAULT_ELEMENT_NAME);
        decision.setDecision(this.expectedDecision);
        result.setDecision(decision);
        result.setStatus((StatusType)this.buildXMLObject(StatusType.DEFAULT_ELEMENT_NAME));
        result.setObligations((ObligationsType)this.buildXMLObject(ObligationsType.DEFAULT_ELEMENT_QNAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)result);
    }
}

