/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.xacml.policy.ActionsType;
import org.opensaml.xacml.policy.AttributeValueType;
import org.opensaml.xacml.policy.impl.AttributeValueTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AttributeValueTest
extends XMLObjectProviderBaseTestCase {
    private String expectedDataType;
    private String expectedValue;
    private QName[] unknownAttributeNames = new QName[]{new QName("urn:foo:bar", "bar", "foo"), new QName("flibble")};
    private String[] unknownAttributeValues = new String[]{"fred", "flobble"};

    public AttributeValueTest() {
        this.singleElementFile = "/data/org/opensaml/xacml/policy/impl/AttributeValue.xml";
        this.singleElementUnknownAttributesFile = "/data/org/opensaml/xacml/policy/impl/AttributeValueUnknownAttributes.xml";
        this.childElementsFile = "/data/org/opensaml/xacml/policy/impl/AttributeValueChildElements.xml";
        this.expectedDataType = "https://example.org/Data/Type";
        this.expectedValue = "Some Text";
    }

    @Test
    public void testSingleElementUnmarshall() {
        AttributeValueType attributeValue = (AttributeValueType)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)attributeValue.getDataType(), (String)this.expectedDataType);
    }

    @Test
    public void testSingleElementMarshall() {
        AttributeValueType attributeValue = new AttributeValueTypeImplBuilder().buildObject();
        attributeValue.setDataType(this.expectedDataType);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)attributeValue);
    }

    @Test
    public void testChildElementsMarshall() {
        AttributeValueType attributeValue = (AttributeValueType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((String)attributeValue.getDataType(), (String)this.expectedDataType);
        Assert.assertEquals((String)attributeValue.getValue(), (String)this.expectedValue);
        int count = 0;
        for (XMLObject o : attributeValue.getUnknownXMLObjects()) {
            Assert.assertTrue((boolean)(o instanceof ActionsType));
            ++count;
        }
        Assert.assertEquals((int)count, (int)3);
        Assert.assertEquals((int)attributeValue.getUnknownXMLObjects(ActionsType.DEFAULT_ELEMENT_NAME).size(), (int)3);
    }

    @Test
    public void testChildElementsUnmarshall() {
        AttributeValueType attributeValue = new AttributeValueTypeImplBuilder().buildObject();
        attributeValue.setDataType(this.expectedDataType);
        attributeValue.setValue(this.expectedValue);
        for (int i = 0; i < 3; ++i) {
            attributeValue.getUnknownXMLObjects().add(this.buildXMLObject(ActionsType.DEFAULT_ELEMENT_NAME));
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)attributeValue);
    }

    @Test
    public void testSingleElementUnknownAttributesMarshall() {
        AttributeValueType attributeValue = (AttributeValueType)this.unmarshallElement(this.singleElementUnknownAttributesFile);
        Assert.assertEquals((String)attributeValue.getDataType(), (String)this.expectedDataType);
        AttributeMap attributes = attributeValue.getUnknownAttributes();
        for (int i = 0; i < this.unknownAttributeNames.length; ++i) {
            Assert.assertEquals((String)attributes.get((Object)this.unknownAttributeNames[i]), (String)this.unknownAttributeValues[i]);
        }
    }

    @Test
    public void testSingleElementUnknownAttributesUnmarshall() {
        AttributeValueType attributeValue = new AttributeValueTypeImplBuilder().buildObject();
        attributeValue.setDataType(this.expectedDataType);
        for (int i = 0; i < this.unknownAttributeNames.length; ++i) {
            attributeValue.getUnknownAttributes().put(this.unknownAttributeNames[i], this.unknownAttributeValues[i]);
        }
        this.assertXMLEquals(this.expectedUnknownAttributesDOM, (XMLObject)attributeValue);
    }
}

