/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.policy.CombinerParameterType;
import org.opensaml.xacml.policy.CombinerParametersType;
import org.opensaml.xacml.policy.impl.CombinerParameterTypeImplBuilder;
import org.opensaml.xacml.policy.impl.CombinerParametersTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CombinerParametersTest
extends XMLObjectProviderBaseTestCase {
    private static final String[] expectedParameterNames = new String[]{"nameParameters-0", "nameParameters-1", "nameParameters-2"};

    public CombinerParametersTest() {
        this.singleElementFile = "/data/org/opensaml/xacml/policy/impl/CombinerParameters.xml";
        this.childElementsFile = "/data/org/opensaml/xacml/policy/impl/CombinerParametersChildElements.xml";
    }

    @Test
    public void testSingleElementUnmarshall() {
        CombinerParametersType combiners = (CombinerParametersType)this.unmarshallElement(this.singleElementFile);
        Assert.assertTrue((boolean)combiners.getCombinerParameters().isEmpty());
    }

    @Test
    public void testSingleElementMarshall() {
        CombinerParametersType combiners = new CombinerParametersTypeImplBuilder().buildObject();
        this.assertXMLEquals(this.expectedDOM, (XMLObject)combiners);
    }

    @Test
    public void testChildElementsMarshall() {
        CombinerParametersType combiners = new CombinerParametersTypeImplBuilder().buildObject();
        for (String paramterName : expectedParameterNames) {
            CombinerParameterType combiner = new CombinerParameterTypeImplBuilder().buildObject();
            combiner.setParameterName(paramterName);
            combiners.getCombinerParameters().add(combiner);
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)combiners);
    }

    @Test
    public void testChildElementsUnmarshall() {
        CombinerParametersType combiners = (CombinerParametersType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)combiners.getCombinerParameters().size(), (int)expectedParameterNames.length);
    }
}

