/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.policy.DefaultsType;
import org.opensaml.xacml.policy.DescriptionType;
import org.opensaml.xacml.policy.EffectType;
import org.opensaml.xacml.policy.PolicyType;
import org.opensaml.xacml.policy.RuleCombinerParametersType;
import org.opensaml.xacml.policy.RuleType;
import org.opensaml.xacml.policy.VariableDefinitionType;
import org.opensaml.xacml.policy.impl.CombinerParametersTypeImplBuilder;
import org.opensaml.xacml.policy.impl.DescriptionTypeImplBuilder;
import org.opensaml.xacml.policy.impl.ObligationsTypeImplBuilder;
import org.opensaml.xacml.policy.impl.PolicyTypeImplBuilder;
import org.opensaml.xacml.policy.impl.RuleCombinerParametersTypeImplBuilder;
import org.opensaml.xacml.policy.impl.RuleTypeImplBuilder;
import org.opensaml.xacml.policy.impl.TargetTypeImplBuilder;
import org.opensaml.xacml.policy.impl.VariableDefinitionTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PolicyTest
extends XMLObjectProviderBaseTestCase {
    private final String expectedVersion;
    private final String expectedPolicyId;
    private final String expectedRuleCombiningAlgId;
    private final int expectedNumCombinerParameters;
    private final int expectedNumRuleCombinerParameters;
    private final int expectedNumVariableDefinitions;
    private final int expectedNumRules;
    private final String expectedDescription;
    private final String expectedRuleCombinerParametersRuleIdRef;
    private final String expectedVariableDefinitionVariableId;
    private final String expectedRuleRuleId;
    private final EffectType expectedRuleEffect;

    public PolicyTest() {
        this.singleElementFile = "/data/org/opensaml/xacml/policy/impl/Policy.xml";
        this.singleElementOptionalAttributesFile = "/data/org/opensaml/xacml/policy/impl/PolicyOptionalAttributes.xml";
        this.childElementsFile = "/data/org/opensaml/xacml/policy/impl/PolicyChildElements.xml";
        this.expectedVersion = "9.9.8";
        this.expectedPolicyId = "https://example.org/Policy/Policy/Id";
        this.expectedRuleCombiningAlgId = "https://example.org/Policy/Rule/Combining/Alg";
        this.expectedNumCombinerParameters = 3;
        this.expectedNumRuleCombinerParameters = 3;
        this.expectedNumVariableDefinitions = 1;
        this.expectedNumRules = 4;
        this.expectedDescription = "This is a Description";
        this.expectedRuleCombinerParametersRuleIdRef = "https://example.org/Rule/Id/Ref";
        this.expectedVariableDefinitionVariableId = "VariableDefinitionId";
        this.expectedRuleRuleId = "RuleRuleId";
        this.expectedRuleEffect = EffectType.Permit;
    }

    @Test
    public void testSingleElementUnmarshall() {
        PolicyType policy = (PolicyType)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)policy.getVersion(), (String)"1.0");
        Assert.assertEquals((String)policy.getPolicyId(), (String)this.expectedPolicyId);
        Assert.assertEquals((String)policy.getRuleCombiningAlgoId(), (String)this.expectedRuleCombiningAlgId);
        Assert.assertNull((Object)policy.getDescription());
        Assert.assertNull((Object)policy.getPolicyDefaults());
        Assert.assertTrue((boolean)policy.getCombinerParameters().isEmpty());
        Assert.assertNull((Object)policy.getTarget());
        Assert.assertTrue((boolean)policy.getRuleCombinerParameters().isEmpty());
        Assert.assertTrue((boolean)policy.getVariableDefinitions().isEmpty());
        Assert.assertTrue((boolean)policy.getRules().isEmpty());
        Assert.assertNull((Object)policy.getObligations());
    }

    @Test
    public void testSingleElementMarshall() {
        PolicyType policy = new PolicyTypeImplBuilder().buildObject();
        Assert.assertEquals((String)policy.getVersion(), (String)"1.0");
        policy.setVersion(null);
        policy.setPolicyId(this.expectedPolicyId);
        policy.setRuleCombiningAlgoId(this.expectedRuleCombiningAlgId);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)policy);
    }

    @Test
    public void testChildElementsUnmarshall() {
        PolicyType policy = (PolicyType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((String)policy.getVersion(), (String)this.expectedVersion);
        Assert.assertEquals((String)policy.getPolicyId(), (String)this.expectedPolicyId);
        Assert.assertEquals((String)policy.getRuleCombiningAlgoId(), (String)this.expectedRuleCombiningAlgId);
        Assert.assertEquals((String)policy.getDescription().getValue(), (String)this.expectedDescription);
        Assert.assertNotNull((Object)policy.getPolicyDefaults());
        Assert.assertEquals((int)policy.getCombinerParameters().size(), (int)this.expectedNumCombinerParameters);
        Assert.assertNotNull((Object)policy.getTarget());
        Assert.assertEquals((int)policy.getRuleCombinerParameters().size(), (int)this.expectedNumRuleCombinerParameters);
        for (RuleCombinerParametersType rcp : policy.getRuleCombinerParameters()) {
            Assert.assertEquals((String)rcp.getRuleIdRef(), (String)this.expectedRuleCombinerParametersRuleIdRef);
        }
        Assert.assertEquals((int)policy.getVariableDefinitions().size(), (int)this.expectedNumVariableDefinitions);
        for (VariableDefinitionType variableDefn : policy.getVariableDefinitions()) {
            Assert.assertEquals((String)variableDefn.getVariableId(), (String)this.expectedVariableDefinitionVariableId);
        }
        Assert.assertEquals((int)policy.getRules().size(), (int)this.expectedNumRules);
        for (RuleType rule : policy.getRules()) {
            Assert.assertEquals((String)rule.getRuleId(), (String)this.expectedRuleRuleId);
            Assert.assertEquals((Object)rule.getEffect(), (Object)this.expectedRuleEffect);
        }
        Assert.assertNotNull((Object)policy.getObligations());
    }

    @Test
    public void testChildElementsMarshall() {
        PolicyType policy = new PolicyTypeImplBuilder().buildObject();
        policy.setVersion(this.expectedVersion);
        policy.setPolicyId(this.expectedPolicyId);
        policy.setRuleCombiningAlgoId(this.expectedRuleCombiningAlgId);
        DescriptionType description = new DescriptionTypeImplBuilder().buildObject();
        description.setValue(this.expectedDescription);
        policy.setDescription(description);
        policy.setPolicyDefaults((DefaultsType)this.buildXMLObject(DefaultsType.POLICY_DEFAULTS_ELEMENT_NAME));
        CombinerParametersTypeImplBuilder combinerBuilder = new CombinerParametersTypeImplBuilder();
        for (int i = 0; i < this.expectedNumCombinerParameters; ++i) {
            policy.getCombinerParameters().add(combinerBuilder.buildObject());
        }
        policy.setTarget(new TargetTypeImplBuilder().buildObject());
        RuleCombinerParametersTypeImplBuilder rcpBuilder = new RuleCombinerParametersTypeImplBuilder();
        for (int i = 0; i < this.expectedNumRuleCombinerParameters; ++i) {
            RuleCombinerParametersType rcp = rcpBuilder.buildObject();
            rcp.setRuleIdRef(this.expectedRuleCombinerParametersRuleIdRef);
            policy.getRuleCombinerParameters().add(rcp);
        }
        VariableDefinitionTypeImplBuilder variableDefnBuilder = new VariableDefinitionTypeImplBuilder();
        for (int i = 0; i < this.expectedNumVariableDefinitions; ++i) {
            VariableDefinitionType variableDefn = variableDefnBuilder.buildObject();
            variableDefn.setVariableId(this.expectedVariableDefinitionVariableId);
            policy.getVariableDefinitions().add(variableDefn);
        }
        RuleTypeImplBuilder ruleBuilder = new RuleTypeImplBuilder();
        for (int i = 0; i < this.expectedNumRules; ++i) {
            RuleType rule = ruleBuilder.buildObject();
            rule.setRuleId(this.expectedRuleRuleId);
            rule.setEffect(this.expectedRuleEffect);
            policy.getRules().add(rule);
        }
        policy.setObligations(new ObligationsTypeImplBuilder().buildObject());
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)policy);
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        PolicyType policy = (PolicyType)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)policy.getVersion(), (String)this.expectedVersion);
        Assert.assertEquals((String)policy.getPolicyId(), (String)this.expectedPolicyId);
        Assert.assertEquals((String)policy.getRuleCombiningAlgoId(), (String)this.expectedRuleCombiningAlgId);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        PolicyType policy = new PolicyTypeImplBuilder().buildObject();
        policy.setVersion(this.expectedVersion);
        policy.setPolicyId(this.expectedPolicyId);
        policy.setRuleCombiningAlgoId(this.expectedRuleCombiningAlgId);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)policy);
    }
}

