/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.policy.SubjectsType;
import org.opensaml.xacml.policy.impl.SubjectTypeImplBuilder;
import org.opensaml.xacml.policy.impl.SubjectsTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SubjectsTest
extends XMLObjectProviderBaseTestCase {
    private int expectedSubjects;

    public SubjectsTest() {
        this.singleElementFile = "/data/org/opensaml/xacml/policy/impl/Subjects.xml";
        this.childElementsFile = "/data/org/opensaml/xacml/policy/impl/SubjectsChildElements.xml";
        this.expectedSubjects = 12;
    }

    @Test
    public void testSingleElementUnmarshall() {
        SubjectsType subjects = (SubjectsType)this.unmarshallElement(this.singleElementFile);
        Assert.assertTrue((boolean)subjects.getSubjects().isEmpty());
    }

    @Test
    public void testSingleElementMarshall() {
        SubjectsType subjects = new SubjectsTypeImplBuilder().buildObject();
        this.assertXMLEquals(this.expectedDOM, (XMLObject)subjects);
    }

    @Test
    public void testChildElementsUnmarshall() {
        SubjectsType subjects = (SubjectsType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)subjects.getSubjects().size(), (int)this.expectedSubjects);
    }

    @Test
    public void testChildElementsMarshall() {
        SubjectsType subjects = new SubjectsTypeImplBuilder().buildObject();
        SubjectTypeImplBuilder builder = new SubjectTypeImplBuilder();
        for (int i = 0; i < this.expectedSubjects; ++i) {
            subjects.getSubjects().add(builder.buildObject());
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)subjects);
    }
}

