/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.policy.TargetType;
import org.opensaml.xacml.policy.impl.ActionsTypeImplBuilder;
import org.opensaml.xacml.policy.impl.EnvironmentsTypeImplBuilder;
import org.opensaml.xacml.policy.impl.ResourcesTypeImplBuilder;
import org.opensaml.xacml.policy.impl.SubjectsTypeImplBuilder;
import org.opensaml.xacml.policy.impl.TargetTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TargetTest
extends XMLObjectProviderBaseTestCase {
    public TargetTest() {
        this.singleElementFile = "/data/org/opensaml/xacml/policy/impl/Target.xml";
        this.childElementsFile = "/data/org/opensaml/xacml/policy/impl/TargetChildElements.xml";
    }

    @Test
    public void testSingleElementUnmarshall() {
        TargetType target = (TargetType)this.unmarshallElement(this.singleElementFile);
        Assert.assertNull((Object)target.getSubjects());
        Assert.assertNull((Object)target.getResources());
        Assert.assertNull((Object)target.getActions());
        Assert.assertNull((Object)target.getEnvironments());
    }

    @Test
    public void testSingleElementMarshall() {
        TargetType target = new TargetTypeImplBuilder().buildObject();
        this.assertXMLEquals(this.expectedDOM, (XMLObject)target);
    }

    @Test
    public void testChildElementsUnmarshall() {
        TargetType target = (TargetType)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)target.getSubjects());
        Assert.assertNotNull((Object)target.getResources());
        Assert.assertNotNull((Object)target.getActions());
        Assert.assertNotNull((Object)target.getEnvironments());
    }

    @Test
    public void testChildElementsMarshall() {
        TargetType target = new TargetTypeImplBuilder().buildObject();
        target.setActions(new ActionsTypeImplBuilder().buildObject());
        target.setEnvironments(new EnvironmentsTypeImplBuilder().buildObject());
        target.setSubjects(new SubjectsTypeImplBuilder().buildObject());
        target.setResources(new ResourcesTypeImplBuilder().buildObject());
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)target);
    }
}

