/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.policy.ExpressionType;
import org.opensaml.xacml.policy.VariableDefinitionType;
import org.opensaml.xacml.policy.VariableReferenceType;
import org.opensaml.xacml.policy.impl.VariableDefinitionTypeImplBuilder;
import org.opensaml.xacml.policy.impl.VariableReferenceTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class VariableDefinitionTest
extends XMLObjectProviderBaseTestCase {
    private String expectedVariableDefinitionId;
    private String expectedVariableReferenceId;

    public VariableDefinitionTest() {
        this.singleElementFile = "/data/org/opensaml/xacml/policy/impl/VariableDefinition.xml";
        this.childElementsFile = "/data/org/opensaml/xacml/policy/impl/VariableDefinitionChildElements.xml";
        this.expectedVariableDefinitionId = "VariableDefinitionId";
        this.expectedVariableReferenceId = "VariableReferenceId";
    }

    @Test
    public void testSingleElementUnmarshall() {
        VariableDefinitionType definition = (VariableDefinitionType)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)definition.getVariableId(), (String)this.expectedVariableDefinitionId);
        Assert.assertNull((Object)definition.getExpression());
    }

    @Test
    public void testSingleElementMarshall() {
        VariableDefinitionType definition = new VariableDefinitionTypeImplBuilder().buildObject();
        definition.setVariableId(this.expectedVariableDefinitionId);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)definition);
    }

    @Test
    public void testChildElementsUnmarshall() {
        VariableDefinitionType definition = (VariableDefinitionType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((String)definition.getVariableId(), (String)this.expectedVariableDefinitionId);
        VariableReferenceType variableReference = (VariableReferenceType)definition.getExpression();
        Assert.assertEquals((String)variableReference.getVariableId(), (String)this.expectedVariableReferenceId);
    }

    @Test
    public void testChildElementsMarshall() {
        VariableDefinitionType definition = new VariableDefinitionTypeImplBuilder().buildObject();
        definition.setVariableId(this.expectedVariableDefinitionId);
        VariableReferenceType variableReference = new VariableReferenceTypeImplBuilder().buildObject();
        variableReference.setVariableId(this.expectedVariableReferenceId);
        definition.setExpression((ExpressionType)variableReference);
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)definition);
    }
}

