/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.ctx.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.ctx.AttributeType;
import org.opensaml.xacml.ctx.ResourceContentType;
import org.opensaml.xacml.ctx.ResourceType;
import org.opensaml.xacml.ctx.impl.ResourceTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ResourceTest
extends XMLObjectProviderBaseTestCase {
    private int expectedNumAttributes;
    private String expectedAttributeId;
    private String expectedDataType;

    public ResourceTest() {
        this.singleElementFile = "/org/opensaml/xacml/ctx/impl/Resource.xml";
        this.childElementsFile = "/org/opensaml/xacml/ctx/impl/ResourceChildElements.xml";
        this.expectedNumAttributes = 3;
        this.expectedAttributeId = "https://example.org/Resource/Attribute/Attribute/Id";
        this.expectedDataType = "https://example.org/Resource/Attribute/Data/Type";
    }

    @Test
    public void testSingleElementUnmarshall() {
        ResourceType resource = (ResourceType)this.unmarshallElement(this.singleElementFile);
        Assert.assertNull((Object)resource.getResourceContent());
        Assert.assertTrue((boolean)resource.getAttributes().isEmpty());
    }

    @Test
    public void testSingleElementMarshall() {
        ResourceType resource = new ResourceTypeImplBuilder().buildObject();
        this.assertXMLEquals(this.expectedDOM, (XMLObject)resource);
    }

    @Test
    public void testChildElementsUnmarshall() {
        ResourceType resource = (ResourceType)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)resource.getResourceContent());
        Assert.assertEquals((int)resource.getAttributes().size(), (int)this.expectedNumAttributes);
        for (AttributeType attribute : resource.getAttributes()) {
            Assert.assertEquals((String)attribute.getAttributeId(), (String)this.expectedAttributeId);
            Assert.assertEquals((String)attribute.getDataType(), (String)this.expectedDataType);
        }
    }

    @Test
    public void testChildElementsMarshall() {
        ResourceType resource = new ResourceTypeImplBuilder().buildObject();
        resource.setResourceContent((ResourceContentType)this.buildXMLObject(ResourceContentType.DEFAULT_ELEMENT_NAME));
        for (int i = 0; i < this.expectedNumAttributes; ++i) {
            AttributeType attribute = (AttributeType)this.buildXMLObject(AttributeType.DEFAULT_ELEMENT_NAME);
            attribute.setAttributeID(this.expectedAttributeId);
            attribute.setDataType(this.expectedDataType);
            resource.getAttributes().add(attribute);
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)resource);
    }
}

