/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.ctx.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.ctx.AttributeType;
import org.opensaml.xacml.ctx.AttributeValueType;
import org.opensaml.xacml.ctx.impl.AttributeTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AttributeTest
extends XMLObjectProviderBaseTestCase {
    private String expectedAttributeId;
    private String expectedDataType;
    private String expectedIssuer;
    private int expectedNumAttributeValues;

    public AttributeTest() {
        this.singleElementFile = "/org/opensaml/xacml/ctx/impl/Attribute.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/xacml/ctx/impl/AttributeOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/xacml/ctx/impl/AttributeChildElements.xml";
        this.expectedAttributeId = "https://example.org/Attribute/Attribute/Id";
        this.expectedDataType = "https://example.org/Attribute/Data/Type";
        this.expectedIssuer = "AttributeIssuer";
        this.expectedNumAttributeValues = 3;
    }

    @Test
    public void testSingleElementUnmarshall() {
        AttributeType attribute = (AttributeType)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)attribute.getAttributeId(), (String)this.expectedAttributeId);
        Assert.assertEquals((String)attribute.getDataType(), (String)this.expectedDataType);
        Assert.assertNull((Object)attribute.getIssuer());
    }

    @Test
    public void testSingleElementMarshall() {
        AttributeType attribute = new AttributeTypeImplBuilder().buildObject();
        attribute.setAttributeID(this.expectedAttributeId);
        attribute.setDataType(this.expectedDataType);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)attribute);
    }

    @Test
    public void testChildElementsUnmarshall() {
        AttributeType attribute = (AttributeType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)attribute.getAttributeValues().size(), (int)this.expectedNumAttributeValues);
        Assert.assertEquals((String)attribute.getAttributeId(), (String)this.expectedAttributeId);
        Assert.assertEquals((String)attribute.getDataType(), (String)this.expectedDataType);
    }

    @Test
    public void testChildElementsMarshall() {
        AttributeType attribute = new AttributeTypeImplBuilder().buildObject();
        attribute.setAttributeID(this.expectedAttributeId);
        attribute.setDataType(this.expectedDataType);
        for (int i = 0; i < this.expectedNumAttributeValues; ++i) {
            attribute.getAttributeValues().add((AttributeValueType)this.buildXMLObject(AttributeValueType.DEFAULT_ELEMENT_NAME));
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)attribute);
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        AttributeType attribute = (AttributeType)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)attribute.getAttributeId(), (String)this.expectedAttributeId);
        Assert.assertEquals((String)attribute.getDataType(), (String)this.expectedDataType);
        Assert.assertEquals((String)attribute.getIssuer(), (String)this.expectedIssuer);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        AttributeType attribute = new AttributeTypeImplBuilder().buildObject();
        attribute.setAttributeID(this.expectedAttributeId);
        attribute.setDataType(this.expectedDataType);
        attribute.setIssuer(this.expectedIssuer);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)attribute);
    }
}

