/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.ctx.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.ctx.AttributeType;
import org.opensaml.xacml.ctx.EnvironmentType;
import org.opensaml.xacml.ctx.impl.EnvironmentTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EnvironmentTest
extends XMLObjectProviderBaseTestCase {
    private int expectedNumResults;
    private String expectedAttributeId;
    private String expectedDataType;

    public EnvironmentTest() {
        this.singleElementFile = "/org/opensaml/xacml/ctx/impl/Environment.xml";
        this.childElementsFile = "/org/opensaml/xacml/ctx/impl/EnvironmentChildElements.xml";
        this.expectedNumResults = 4;
        this.expectedAttributeId = "https://example.org/Environment/Attribute/Attribute/Id";
        this.expectedDataType = "https://example.org/Environment/Attribute/Data/Type";
    }

    @Test
    public void testSingleElementUnmarshall() {
        EnvironmentType environment = (EnvironmentType)this.unmarshallElement(this.singleElementFile);
        Assert.assertTrue((boolean)environment.getAttributes().isEmpty());
    }

    @Test
    public void testSingleElementMarshall() {
        EnvironmentType environment = new EnvironmentTypeImplBuilder().buildObject();
        this.assertXMLEquals(this.expectedDOM, (XMLObject)environment);
    }

    @Test
    public void testChildElementsUnmarshall() {
        EnvironmentType environment = (EnvironmentType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)environment.getAttributes().size(), (int)this.expectedNumResults);
        for (AttributeType attribute : environment.getAttributes()) {
            Assert.assertEquals((String)attribute.getAttributeId(), (String)this.expectedAttributeId);
            Assert.assertEquals((String)attribute.getDataType(), (String)this.expectedDataType);
        }
    }

    @Test
    public void testChildElementsMarshall() {
        EnvironmentType environment = new EnvironmentTypeImplBuilder().buildObject();
        for (int i = 0; i < this.expectedNumResults; ++i) {
            AttributeType attribute = (AttributeType)this.buildXMLObject(AttributeType.DEFAULT_ELEMENT_NAME);
            attribute.setAttributeID(this.expectedAttributeId);
            attribute.setDataType(this.expectedDataType);
            environment.getAttributes().add(attribute);
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)environment);
    }
}

