/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.ctx.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.ctx.ResourceContentType;
import org.opensaml.xacml.ctx.impl.ResourceContentTypeImplBuilder;
import org.opensaml.xacml.policy.ActionType;
import org.opensaml.xacml.policy.ApplyType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ResourceContentTest
extends XMLObjectProviderBaseTestCase {
    private String expectedFunctionId;
    private QName[] expectedAttributeName = new QName[]{new QName("foorc"), new QName("urn:oasis:names:tc:xacml:2.0:policy:schema:os", "rcbar", "xacml")};
    private String[] expectedAttributeValue = new String[]{"barrc", "rcfoo"};
    private String expectedContent;

    public ResourceContentTest() {
        this.singleElementFile = "/org/opensaml/xacml/ctx/impl/ResourceContent.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/xacml/ctx/impl/ResourceContentOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/xacml/ctx/impl/ResourceContentChildElements.xml";
        this.expectedFunctionId = "http://example.org/Resource/Content/Apply/Function/Id";
        this.expectedContent = "ResourceContentText";
    }

    @Test
    public void testSingleElementUnmarshall() {
        ResourceContentType resourceContent = (ResourceContentType)this.unmarshallElement(this.singleElementFile);
        Assert.assertTrue((boolean)resourceContent.getUnknownAttributes().isEmpty());
        Assert.assertTrue((boolean)resourceContent.getUnknownXMLObjects().isEmpty());
    }

    @Test
    public void testSingleElementMarshall() {
        ResourceContentType resourceContent = new ResourceContentTypeImplBuilder().buildObject();
        Assert.assertTrue((boolean)resourceContent.getUnknownXMLObjects().isEmpty());
        Assert.assertNull((Object)resourceContent.getValue());
        this.assertXMLEquals(this.expectedDOM, (XMLObject)resourceContent);
    }

    @Test
    public void testChildElementsUnmarshall() {
        ResourceContentType resourceContent = (ResourceContentType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)resourceContent.getUnknownXMLObjects().size(), (int)2);
        Assert.assertNotNull((Object)resourceContent.getUnknownXMLObjects(ActionType.DEFAULT_ELEMENT_NAME));
        Assert.assertEquals((String)((ApplyType)resourceContent.getUnknownXMLObjects(ApplyType.DEFAULT_ELEMENT_NAME).get(0)).getFunctionId(), (String)this.expectedFunctionId);
    }

    @Test
    public void testChildElementsMarshall() {
        ResourceContentType resourceContent = new ResourceContentTypeImplBuilder().buildObject();
        resourceContent.getUnknownXMLObjects().add(this.buildXMLObject(ActionType.DEFAULT_ELEMENT_NAME));
        ApplyType apply = (ApplyType)this.buildXMLObject(ApplyType.DEFAULT_ELEMENT_NAME);
        apply.setFunctionId(this.expectedFunctionId);
        resourceContent.getUnknownXMLObjects().add(apply);
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)resourceContent);
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        ResourceContentType resourceContent = (ResourceContentType)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)resourceContent.getValue(), (String)this.expectedContent);
        Assert.assertEquals((int)resourceContent.getUnknownAttributes().size(), (int)this.expectedAttributeValue.length);
        for (int i = 0; i < this.expectedAttributeValue.length; ++i) {
            Assert.assertEquals((String)resourceContent.getUnknownAttributes().get((Object)this.expectedAttributeName[i]), (String)this.expectedAttributeValue[i]);
        }
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        ResourceContentType resourceContent = new ResourceContentTypeImplBuilder().buildObject();
        resourceContent.setValue(this.expectedContent);
        for (int i = 0; i < this.expectedAttributeValue.length; ++i) {
            resourceContent.getUnknownAttributes().put(this.expectedAttributeName[i], this.expectedAttributeValue[i]);
        }
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)resourceContent);
    }
}

