/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.ctx.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.ctx.AttributeType;
import org.opensaml.xacml.ctx.SubjectType;
import org.opensaml.xacml.ctx.impl.SubjectTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SubjectTest
extends XMLObjectProviderBaseTestCase {
    private int expectedNumAttributes;
    private String expectedAttributeId;
    private String expectedDataType;
    private String expectedSubjectCategory;

    public SubjectTest() {
        this.singleElementFile = "/org/opensaml/xacml/ctx/impl/Subject.xml";
        this.childElementsFile = "/org/opensaml/xacml/ctx/impl/SubjectChildElements.xml";
        this.expectedSubjectCategory = "https://example.org/Subject/Subject/Category";
        this.expectedAttributeId = "https://example.org/Subject/Attribute/Attribute/Id";
        this.expectedDataType = "https://example.org/Subject/Attribute/Data/Type";
        this.expectedNumAttributes = 2;
    }

    @Test
    public void testSingleElementUnmarshall() {
        SubjectType subject = (SubjectType)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)subject.getSubjectCategory(), (String)"urn:oasis:names:tc:xacml:1.0:subject-category:access-subject");
        Assert.assertTrue((boolean)subject.getAttributes().isEmpty());
    }

    @Test
    public void testSingleElementMarshall() {
        SubjectType subject = new SubjectTypeImplBuilder().buildObject();
        Assert.assertEquals((String)subject.getSubjectCategory(), (String)"urn:oasis:names:tc:xacml:1.0:subject-category:access-subject");
        subject.setSubjectCategory(null);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)subject);
    }

    @Test
    public void testChildElementsUnmarshall() {
        SubjectType subject = (SubjectType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((String)subject.getSubjectCategory(), (String)this.expectedSubjectCategory);
        Assert.assertEquals((int)subject.getAttributes().size(), (int)this.expectedNumAttributes);
        for (AttributeType attribute : subject.getAttributes()) {
            Assert.assertEquals((String)attribute.getAttributeId(), (String)this.expectedAttributeId);
            Assert.assertEquals((String)attribute.getDataType(), (String)this.expectedDataType);
        }
    }

    @Test
    public void testChildElementsMarshall() {
        SubjectType subject = new SubjectTypeImplBuilder().buildObject();
        subject.setSubjectCategory(this.expectedSubjectCategory);
        for (int i = 0; i < this.expectedNumAttributes; ++i) {
            AttributeType attribute = (AttributeType)this.buildXMLObject(AttributeType.DEFAULT_ELEMENT_NAME);
            attribute.setAttributeID(this.expectedAttributeId);
            attribute.setDataType(this.expectedDataType);
            subject.getAttributes().add(attribute);
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)subject);
    }
}

