/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.policy.EnvironmentMatchType;
import org.opensaml.xacml.policy.EnvironmentType;
import org.opensaml.xacml.policy.impl.EnvironmentMatchTypeImplBuilder;
import org.opensaml.xacml.policy.impl.EnvironmentTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EnvironmentTest
extends XMLObjectProviderBaseTestCase {
    private String expectedMatchId;
    private int expectedNumChildren;

    public EnvironmentTest() {
        this.singleElementFile = "/org/opensaml/xacml/policy/impl/Environment.xml";
        this.childElementsFile = "/org/opensaml/xacml/policy/impl/EnvironmentChildElements.xml";
        this.expectedMatchId = "https://example.org/Environment/Id";
        this.expectedNumChildren = 7;
    }

    @Test
    public void testSingleElementUnmarshall() {
        EnvironmentType environment = (EnvironmentType)this.unmarshallElement(this.singleElementFile);
        Assert.assertTrue((boolean)environment.getEnvrionmentMatches().isEmpty());
    }

    @Test
    public void testSingleElementMarshall() {
        EnvironmentType environment = new EnvironmentTypeImplBuilder().buildObject();
        this.assertXMLEquals(this.expectedDOM, (XMLObject)environment);
    }

    @Test
    public void testChildElementsMarshall() {
        EnvironmentType environment = new EnvironmentTypeImplBuilder().buildObject();
        EnvironmentMatchTypeImplBuilder builder = new EnvironmentMatchTypeImplBuilder();
        for (int i = 0; i < this.expectedNumChildren; ++i) {
            EnvironmentMatchType environmentMatch = builder.buildObject();
            environmentMatch.setMatchId(this.expectedMatchId);
            environment.getEnvrionmentMatches().add(environmentMatch);
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)environment);
    }

    @Test
    public void testChildElementsUnmarshall() {
        EnvironmentType environment = (EnvironmentType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)environment.getEnvrionmentMatches().size(), (int)this.expectedNumChildren);
        for (EnvironmentMatchType environmentMatch : environment.getEnvrionmentMatches()) {
            Assert.assertEquals((String)environmentMatch.getMatchId(), (String)this.expectedMatchId);
        }
    }
}

