/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.policy.EnvironmentType;
import org.opensaml.xacml.policy.EnvironmentsType;
import org.opensaml.xacml.policy.impl.EnvironmentTypeImplBuilder;
import org.opensaml.xacml.policy.impl.EnvironmentsTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EnvironmentsTest
extends XMLObjectProviderBaseTestCase {
    private int expectedNumChildren;

    public EnvironmentsTest() {
        this.singleElementFile = "/org/opensaml/xacml/policy/impl/Environments.xml";
        this.childElementsFile = "/org/opensaml/xacml/policy/impl/EnvironmentsChildElements.xml";
        this.expectedNumChildren = 4;
    }

    @Test
    public void testSingleElementUnmarshall() {
        EnvironmentsType environments = (EnvironmentsType)this.unmarshallElement(this.singleElementFile);
        Assert.assertTrue((boolean)environments.getEnvironments().isEmpty());
    }

    @Test
    public void testSingleElementMarshall() {
        EnvironmentsType environments = new EnvironmentsTypeImplBuilder().buildObject();
        this.assertXMLEquals(this.expectedDOM, (XMLObject)environments);
    }

    @Test
    public void testChildElementsMarshall() {
        EnvironmentsType environments = new EnvironmentsTypeImplBuilder().buildObject();
        EnvironmentTypeImplBuilder builder = new EnvironmentTypeImplBuilder();
        for (int i = 0; i < this.expectedNumChildren; ++i) {
            environments.getEnvironments().add(builder.buildObject());
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)environments);
    }

    @Test
    public void testChildElementsUnmarshall() {
        EnvironmentsType environments = (EnvironmentsType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)environments.getEnvironments().size(), (int)this.expectedNumChildren);
        for (EnvironmentType environment : environments.getEnvironments()) {
            Assert.assertTrue((boolean)environment.getEnvrionmentMatches().isEmpty());
        }
    }
}

