/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.policy.AttributeAssignmentType;
import org.opensaml.xacml.policy.EffectType;
import org.opensaml.xacml.policy.ObligationType;
import org.opensaml.xacml.policy.impl.AttributeAssignmentTypeImplBuilder;
import org.opensaml.xacml.policy.impl.ObligationTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ObligationTest
extends XMLObjectProviderBaseTestCase {
    private String expectedObligationId;
    private EffectType expectedFulFillOn;
    private int expectedAttributeAssignments = 2;
    private String expectedDataType;
    private String expectedAttributeId;

    public ObligationTest() {
        this.singleElementFile = "/org/opensaml/xacml/policy/impl/Obligation.xml";
        this.childElementsFile = "/org/opensaml/xacml/policy/impl/ObligationChildElements.xml";
        this.expectedObligationId = "http://example.org/Obligation/Id";
        this.expectedFulFillOn = EffectType.Deny;
        this.expectedAttributeAssignments = 2;
        this.expectedDataType = "https://example.org/Obligation/Id/Data/Type";
        this.expectedAttributeId = "https://example.org/Obligation/Id/Attribute/Id";
    }

    @Test
    public void testSingleElementUnmarshall() {
        ObligationType obligation = (ObligationType)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)obligation.getObligationId(), (String)this.expectedObligationId);
        Assert.assertEquals((Object)obligation.getFulfillOn(), (Object)this.expectedFulFillOn);
        Assert.assertTrue((boolean)obligation.getAttributeAssignments().isEmpty());
    }

    @Test
    public void testSingleElementMarshall() {
        ObligationType obligation = new ObligationTypeImplBuilder().buildObject();
        obligation.setObligationId(this.expectedObligationId);
        obligation.setFulfillOn(this.expectedFulFillOn);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)obligation);
    }

    @Test
    public void testChildElementsUnmarshall() {
        ObligationType obligation = (ObligationType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((String)obligation.getObligationId(), (String)this.expectedObligationId);
        Assert.assertEquals((Object)obligation.getFulfillOn(), (Object)this.expectedFulFillOn);
        Assert.assertEquals((int)obligation.getAttributeAssignments().size(), (int)this.expectedAttributeAssignments);
        for (AttributeAssignmentType attributeAssignment : obligation.getAttributeAssignments()) {
            Assert.assertEquals((String)attributeAssignment.getAttributeId(), (String)this.expectedAttributeId);
            Assert.assertEquals((String)attributeAssignment.getDataType(), (String)this.expectedDataType);
        }
    }

    @Test
    public void testChildElementsMarshall() {
        ObligationType obligation = new ObligationTypeImplBuilder().buildObject();
        AttributeAssignmentTypeImplBuilder builder = new AttributeAssignmentTypeImplBuilder();
        obligation.setObligationId(this.expectedObligationId);
        obligation.setFulfillOn(this.expectedFulFillOn);
        for (int i = 0; i < this.expectedAttributeAssignments; ++i) {
            AttributeAssignmentType attributeAssignment = builder.buildObject();
            attributeAssignment.setAttributeId(this.expectedAttributeId);
            attributeAssignment.setDataType(this.expectedDataType);
            obligation.getAttributeAssignments().add(attributeAssignment);
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)obligation);
    }
}

