/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.xacml.policy.DefaultsType;
import org.opensaml.xacml.policy.XPathVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PolicyDefaultsTest
extends XMLObjectProviderBaseTestCase {
    private static final String EXPECTED_XPATH_VERSION = "https://example.org/Policy/Defaults/Xpath/Version";

    public PolicyDefaultsTest() {
        this.singleElementFile = "/org/opensaml/xacml/policy/impl/PolicyDefaults.xml";
        this.childElementsFile = "/org/opensaml/xacml/policy/impl/PolicyDefaultsChildElements.xml";
    }

    @Test
    public void testSingleElementUnmarshall() {
        DefaultsType policyDefaults = (DefaultsType)this.unmarshallElement(this.singleElementFile);
        Assert.assertNull((Object)policyDefaults.getXPathVersion());
    }

    @Test
    public void testSingleElementMarshall() {
        DefaultsType policyDefaults = (DefaultsType)this.buildXMLObject(DefaultsType.POLICY_DEFAULTS_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)policyDefaults);
    }

    @Test
    public void testChildElementsMarshall() {
        DefaultsType policyDefaults = (DefaultsType)this.buildXMLObject(DefaultsType.POLICY_DEFAULTS_ELEMENT_NAME);
        XSString xpath = (XSString)this.buildXMLObject(XPathVersion.DEFAULTS_ELEMENT_NAME);
        xpath.setValue(EXPECTED_XPATH_VERSION);
        policyDefaults.setXPathVersion(xpath);
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)policyDefaults);
    }

    @Test
    public void testChildElementsUnmarshall() {
        DefaultsType policyDefaults = (DefaultsType)this.unmarshallElement(this.childElementsFile);
        XSString xpath = policyDefaults.getXPathVersion();
        Assert.assertEquals((String)xpath.getValue(), (String)EXPECTED_XPATH_VERSION);
        Assert.assertEquals((Object)xpath.getElementQName(), (Object)XPathVersion.DEFAULTS_ELEMENT_NAME);
    }
}

