/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.xacml.policy.DefaultsType;
import org.opensaml.xacml.policy.XPathVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PolicySetDefaultsTest
extends XMLObjectProviderBaseTestCase {
    private static final String EXPECTED_XPATH_VERSION = "https://example.org/Policy/Set/Defaults/Xpath/Version";

    public PolicySetDefaultsTest() {
        this.singleElementFile = "/org/opensaml/xacml/policy/impl/PolicySetDefaults.xml";
        this.childElementsFile = "/org/opensaml/xacml/policy/impl/PolicySetDefaultsChildElements.xml";
    }

    @Test
    public void testSingleElementUnmarshall() {
        DefaultsType policySetDefaults = (DefaultsType)this.unmarshallElement(this.singleElementFile);
        Assert.assertNull((Object)policySetDefaults.getXPathVersion());
    }

    @Test
    public void testSingleElementMarshall() {
        DefaultsType policySetDefaults = (DefaultsType)this.buildXMLObject(DefaultsType.POLICY_SET_DEFAULTS_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)policySetDefaults);
    }

    @Test
    public void testChildElementsMarshall() {
        DefaultsType policySetDefaults = (DefaultsType)this.buildXMLObject(DefaultsType.POLICY_SET_DEFAULTS_ELEMENT_NAME);
        XSString xpath = (XSString)this.buildXMLObject(XPathVersion.DEFAULTS_ELEMENT_NAME);
        xpath.setValue(EXPECTED_XPATH_VERSION);
        policySetDefaults.setXPathVersion(xpath);
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)policySetDefaults);
    }

    @Test
    public void testChildElementsUnmarshall() {
        DefaultsType policySetDefaults = (DefaultsType)this.unmarshallElement(this.childElementsFile);
        XSString xpath = policySetDefaults.getXPathVersion();
        Assert.assertEquals((String)xpath.getValue(), (String)EXPECTED_XPATH_VERSION);
        Assert.assertEquals((Object)xpath.getElementQName(), (Object)XPathVersion.DEFAULTS_ELEMENT_NAME);
    }
}

