/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.policy.IdReferenceType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PolicySetIdReferenceTest
extends XMLObjectProviderBaseTestCase {
    private String expectedReference;
    private String expectedVersion;
    private String expectedEarliestVersion;
    private String expectedLatestVersion;

    public PolicySetIdReferenceTest() {
        this.singleElementFile = "/org/opensaml/xacml/policy/impl/PolicySetIdReference.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/xacml/policy/impl/PolicySetIdReferenceOptionalAttributes.xml";
        this.expectedReference = "https://example.org/Policy/Set/Id/Reference";
        this.expectedVersion = "1.2.*";
        this.expectedEarliestVersion = "1.1.+";
        this.expectedLatestVersion = "1.3.99";
    }

    @Test
    public void testSingleElementUnmarshall() {
        IdReferenceType policySetIdReference = (IdReferenceType)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)policySetIdReference.getValue(), (String)this.expectedReference);
    }

    @Test
    public void testSingleElementMarshall() {
        IdReferenceType policySetIdReference = (IdReferenceType)this.buildXMLObject(IdReferenceType.POLICY_SET_ID_REFERENCE_ELEMENT_NAME);
        policySetIdReference.setValue(this.expectedReference);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)policySetIdReference);
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        IdReferenceType policySetIdReference = (IdReferenceType)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)policySetIdReference.getValue(), (String)this.expectedReference);
        Assert.assertEquals((String)policySetIdReference.getVersion(), (String)this.expectedVersion);
        Assert.assertEquals((String)policySetIdReference.getEarliestVersion(), (String)this.expectedEarliestVersion);
        Assert.assertEquals((String)policySetIdReference.getLatestVersion(), (String)this.expectedLatestVersion);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        IdReferenceType policySetIdReference = (IdReferenceType)this.buildXMLObject(IdReferenceType.POLICY_SET_ID_REFERENCE_ELEMENT_NAME);
        policySetIdReference.setValue(this.expectedReference);
        policySetIdReference.setVersion(this.expectedVersion);
        policySetIdReference.setEarliestVersion(this.expectedEarliestVersion);
        policySetIdReference.setLatestVersion(this.expectedLatestVersion);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)policySetIdReference);
    }
}

