/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.policy.CombinerParametersType;
import org.opensaml.xacml.policy.DefaultsType;
import org.opensaml.xacml.policy.DescriptionType;
import org.opensaml.xacml.policy.IdReferenceType;
import org.opensaml.xacml.policy.PolicyCombinerParametersType;
import org.opensaml.xacml.policy.PolicySetCombinerParametersType;
import org.opensaml.xacml.policy.PolicySetType;
import org.opensaml.xacml.policy.PolicyType;
import org.opensaml.xacml.policy.TargetType;
import org.opensaml.xacml.policy.impl.DescriptionTypeImplBuilder;
import org.opensaml.xacml.policy.impl.ObligationsTypeImplBuilder;
import org.opensaml.xacml.policy.impl.PolicySetTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PolicySetTest
extends XMLObjectProviderBaseTestCase {
    private final String expectedVersion;
    private final String expectedPolicySetId;
    private final String expectedPolicyCombiningAlgId;
    private final int expectedNumPolicySet;
    private final int expectedNumPolicy;
    private final int expectedNumPolicySetIdReference;
    private final int expectedNumPolicyIdReference;
    private final int expectedNumCombinerParameters;
    private final int expectedNumPolicyCombinerParameters;
    private final int expectedNumPolicySetCombinerParameters;
    private final String expectedDescription;
    private final String expectedPolicyId;
    private final String expectedRuleCombiningAlgId;
    private final String expectedPolicySetIdReference;
    private final String expectedPolicyIdReference;

    public PolicySetTest() {
        this.singleElementFile = "/org/opensaml/xacml/policy/impl/PolicySet.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/xacml/policy/impl/PolicySetOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/xacml/policy/impl/PolicySetChildElements.xml";
        this.expectedVersion = "8.7.6";
        this.expectedPolicySetId = "https://example.org/Policy/Set/Policy/Set/Id";
        this.expectedPolicyCombiningAlgId = "https://example.org/Policy/Set/Policy/Combining/Alg/Id";
        this.expectedNumPolicySet = 2;
        this.expectedNumPolicy = 2;
        this.expectedNumPolicySetIdReference = 3;
        this.expectedNumPolicyIdReference = 4;
        this.expectedNumCombinerParameters = 1;
        this.expectedNumPolicyCombinerParameters = 3;
        this.expectedNumPolicySetCombinerParameters = 2;
        this.expectedDescription = "This is a Description";
        this.expectedPolicyId = "https://example.org/Policy/Policy/Id";
        this.expectedRuleCombiningAlgId = "https://example.org/Policy/Rule/Combining/Alg";
        this.expectedPolicySetIdReference = "https://example.org/Policy/Set/Policy/Set/Id/Ref";
        this.expectedPolicyIdReference = "https://example.org/Policy/Set/Policy/Id/Ref";
    }

    @Test
    public void testSingleElementUnmarshall() {
        PolicySetType policySet = (PolicySetType)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)policySet.getVersion(), (String)"1.0");
        Assert.assertEquals((String)policySet.getPolicySetId(), (String)this.expectedPolicySetId);
        Assert.assertEquals((String)policySet.getPolicyCombiningAlgoId(), (String)this.expectedPolicyCombiningAlgId);
        Assert.assertNull((Object)policySet.getDescription());
        Assert.assertNull((Object)policySet.getPolicySetDefaults());
        Assert.assertNull((Object)policySet.getTarget());
        Assert.assertTrue((boolean)policySet.getPolicySets().isEmpty());
        Assert.assertTrue((boolean)policySet.getPolicies().isEmpty());
        Assert.assertTrue((boolean)policySet.getPolicySetIdReferences().isEmpty());
        Assert.assertTrue((boolean)policySet.getPolicyIdReferences().isEmpty());
        Assert.assertTrue((boolean)policySet.getCombinerParameters().isEmpty());
        Assert.assertTrue((boolean)policySet.getPolicyCombinerParameters().isEmpty());
        Assert.assertTrue((boolean)policySet.getPolicySetCombinerParameters().isEmpty());
        Assert.assertTrue((boolean)policySet.getPolicyChoiceGroup().isEmpty());
        Assert.assertNull((Object)policySet.getObligations());
    }

    @Test
    public void testSingleElementMarshall() {
        PolicySetType policySet = new PolicySetTypeImplBuilder().buildObject();
        Assert.assertEquals((String)policySet.getVersion(), (String)"1.0");
        policySet.setVersion(null);
        policySet.setPolicySetId(this.expectedPolicySetId);
        policySet.setPolicyCombiningAlgoId(this.expectedPolicyCombiningAlgId);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)policySet);
    }

    @Test
    public void testChildElementsUnmarshall() {
        PolicySetType policySet = (PolicySetType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((String)policySet.getPolicySetId(), (String)this.expectedPolicySetId);
        Assert.assertEquals((String)policySet.getPolicyCombiningAlgoId(), (String)this.expectedPolicyCombiningAlgId);
        Assert.assertEquals((String)policySet.getVersion(), (String)this.expectedVersion);
        Assert.assertEquals((String)policySet.getDescription().getValue(), (String)this.expectedDescription);
        Assert.assertNotNull((Object)policySet.getPolicySetDefaults());
        Assert.assertNotNull((Object)policySet.getTarget());
        Assert.assertEquals((int)policySet.getPolicySets().size(), (int)this.expectedNumPolicySet);
        for (PolicySetType myPolicySet : policySet.getPolicySets()) {
            Assert.assertEquals((String)myPolicySet.getPolicySetId(), (String)this.expectedPolicySetId);
            Assert.assertEquals((String)myPolicySet.getPolicyCombiningAlgoId(), (String)this.expectedPolicyCombiningAlgId);
            Assert.assertEquals((String)myPolicySet.getVersion(), (String)this.expectedVersion);
        }
        Assert.assertEquals((int)policySet.getPolicies().size(), (int)this.expectedNumPolicy);
        for (PolicyType policy : policySet.getPolicies()) {
            Assert.assertEquals((String)policy.getPolicyId(), (String)this.expectedPolicyId);
            Assert.assertEquals((String)policy.getRuleCombiningAlgoId(), (String)this.expectedRuleCombiningAlgId);
            Assert.assertEquals((String)policy.getVersion(), (String)this.expectedVersion);
        }
        Assert.assertEquals((int)policySet.getPolicySetIdReferences().size(), (int)this.expectedNumPolicySetIdReference);
        for (IdReferenceType idRef : policySet.getPolicySetIdReferences()) {
            Assert.assertEquals((String)idRef.getValue(), (String)this.expectedPolicySetIdReference);
        }
        Assert.assertEquals((int)policySet.getPolicyIdReferences().size(), (int)this.expectedNumPolicyIdReference);
        for (IdReferenceType idRef : policySet.getPolicyIdReferences()) {
            Assert.assertEquals((String)idRef.getValue(), (String)this.expectedPolicyIdReference);
        }
        Assert.assertEquals((int)policySet.getCombinerParameters().size(), (int)this.expectedNumCombinerParameters);
        Assert.assertEquals((int)policySet.getPolicyCombinerParameters().size(), (int)this.expectedNumPolicyCombinerParameters);
        for (PolicyCombinerParametersType pcp : policySet.getPolicyCombinerParameters()) {
            Assert.assertEquals((String)pcp.getPolicyIdRef(), (String)this.expectedPolicyIdReference);
        }
        Assert.assertEquals((int)policySet.getPolicySetCombinerParameters().size(), (int)this.expectedNumPolicySetCombinerParameters);
        for (PolicySetCombinerParametersType pscp : policySet.getPolicySetCombinerParameters()) {
            Assert.assertEquals((String)pscp.getPolicySetIdRef(), (String)this.expectedPolicySetIdReference);
        }
        Assert.assertEquals((int)policySet.getPolicyChoiceGroup().size(), (int)(this.expectedNumCombinerParameters + this.expectedNumPolicy + this.expectedNumPolicyCombinerParameters + this.expectedNumPolicyIdReference + this.expectedNumPolicySetCombinerParameters + this.expectedNumPolicySetIdReference + this.expectedNumPolicySet));
        Assert.assertNotNull((Object)policySet.getObligations());
    }

    @Test
    public void testChildElementsMarshall() {
        IdReferenceType ref;
        int i;
        PolicySetType policySet = new PolicySetTypeImplBuilder().buildObject();
        policySet.setVersion(this.expectedVersion);
        policySet.setPolicySetId(this.expectedPolicySetId);
        policySet.setPolicyCombiningAlgoId(this.expectedPolicyCombiningAlgId);
        DescriptionType description = new DescriptionTypeImplBuilder().buildObject();
        description.setValue(this.expectedDescription);
        policySet.setDescription(description);
        policySet.setPolicySetDefaults((DefaultsType)this.buildXMLObject(DefaultsType.POLICY_SET_DEFAULTS_ELEMENT_NAME));
        policySet.setTarget((TargetType)this.buildXMLObject(TargetType.DEFAULT_ELEMENT_NAME));
        for (i = 0; i < this.expectedNumPolicySet; ++i) {
            PolicySetType myPolicySet = (PolicySetType)this.buildXMLObject(PolicySetType.DEFAULT_ELEMENT_NAME);
            myPolicySet.setVersion(this.expectedVersion);
            myPolicySet.setPolicySetId(this.expectedPolicySetId);
            myPolicySet.setPolicyCombiningAlgoId(this.expectedPolicyCombiningAlgId);
            policySet.getPolicySets().add(myPolicySet);
        }
        for (i = 0; i < this.expectedNumPolicy; ++i) {
            PolicyType policy = (PolicyType)this.buildXMLObject(PolicyType.DEFAULT_ELEMENT_NAME);
            policy.setVersion(this.expectedVersion);
            policy.setPolicyId(this.expectedPolicyId);
            policy.setRuleCombiningAlgoId(this.expectedRuleCombiningAlgId);
            policySet.getPolicies().add(policy);
        }
        for (i = 0; i < this.expectedNumPolicySetIdReference; ++i) {
            ref = (IdReferenceType)this.buildXMLObject(IdReferenceType.POLICY_SET_ID_REFERENCE_ELEMENT_NAME);
            ref.setValue(this.expectedPolicySetIdReference);
            policySet.getPolicySetIdReferences().add(ref);
        }
        for (i = 0; i < this.expectedNumPolicyIdReference; ++i) {
            ref = (IdReferenceType)this.buildXMLObject(IdReferenceType.POLICY_ID_REFERENCE_ELEMENT_NAME);
            ref.setValue(this.expectedPolicyIdReference);
            policySet.getPolicySetIdReferences().add(ref);
        }
        for (i = 0; i < this.expectedNumCombinerParameters; ++i) {
            policySet.getCombinerParameters().add((CombinerParametersType)this.buildXMLObject(CombinerParametersType.DEFAULT_ELEMENT_NAME));
        }
        for (i = 0; i < this.expectedNumPolicyCombinerParameters; ++i) {
            PolicyCombinerParametersType pcp = (PolicyCombinerParametersType)this.buildXMLObject(PolicyCombinerParametersType.DEFAULT_ELEMENT_NAME);
            pcp.setPolicyIdRef(this.expectedPolicyIdReference);
            policySet.getPolicyCombinerParameters().add(pcp);
        }
        for (i = 0; i < this.expectedNumPolicySetCombinerParameters; ++i) {
            PolicySetCombinerParametersType pscp = (PolicySetCombinerParametersType)this.buildXMLObject(PolicySetCombinerParametersType.DEFAULT_ELEMENT_NAME);
            pscp.setPolicySetIdRef(this.expectedPolicySetIdReference);
            policySet.getPolicySetCombinerParameters().add(pscp);
        }
        policySet.setObligations(new ObligationsTypeImplBuilder().buildObject());
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)policySet);
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        PolicySetType policySet = (PolicySetType)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)policySet.getVersion(), (String)this.expectedVersion);
        Assert.assertEquals((String)policySet.getPolicySetId(), (String)this.expectedPolicySetId);
        Assert.assertEquals((String)policySet.getPolicyCombiningAlgoId(), (String)this.expectedPolicyCombiningAlgId);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        PolicySetType policySet = new PolicySetTypeImplBuilder().buildObject();
        policySet.setVersion(this.expectedVersion);
        policySet.setPolicySetId(this.expectedPolicySetId);
        policySet.setPolicyCombiningAlgoId(this.expectedPolicyCombiningAlgId);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)policySet);
    }
}

