/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.policy.AttributeDesignatorType;
import org.opensaml.xacml.policy.AttributeSelectorType;
import org.opensaml.xacml.policy.AttributeValueType;
import org.opensaml.xacml.policy.ResourceMatchType;
import org.opensaml.xacml.policy.impl.AttributeSelectorTypeImplBuilder;
import org.opensaml.xacml.policy.impl.AttributeValueTypeImplBuilder;
import org.opensaml.xacml.policy.impl.ResourceMatchTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ResourceMatchTest
extends XMLObjectProviderBaseTestCase {
    private String expectedMatchId;
    private String expectedDataType;
    private String expectedAttributeId;
    private String expectedRequestContextPath;

    public ResourceMatchTest() {
        this.singleElementFile = "/org/opensaml/xacml/policy/impl/ResourceMatch.xml";
        this.childElementsFile = "/org/opensaml/xacml/policy/impl/ResourceMatchChildElements.xml";
        this.expectedMatchId = "http://example.org/Resource/Match/Match/Id";
        this.expectedDataType = "https://example.org/Resource/Match/Data/Type";
        this.expectedAttributeId = "https://example.org/Resource/Match/Attribute/Id";
        this.expectedRequestContextPath = "ResourceMatchAttrSelectConextPath";
    }

    @Test
    public void testSingleElementUnmarshall() {
        ResourceMatchType resourceMatch = (ResourceMatchType)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)resourceMatch.getMatchId(), (String)this.expectedMatchId);
        Assert.assertNull((Object)resourceMatch.getAttributeValue());
        Assert.assertNull((Object)resourceMatch.getResourceAttributeDesignator());
        Assert.assertNull((Object)resourceMatch.getAttributeSelector());
    }

    @Test
    public void testSingleElementMarshall() {
        ResourceMatchType resourceMatch = new ResourceMatchTypeImplBuilder().buildObject();
        resourceMatch.setMatchId(this.expectedMatchId);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)resourceMatch);
    }

    @Test
    public void testChildElementsUnmarshall() {
        ResourceMatchType resourceMatch = (ResourceMatchType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((String)resourceMatch.getMatchId(), (String)this.expectedMatchId);
        Assert.assertEquals((String)resourceMatch.getAttributeValue().getDataType(), (String)this.expectedDataType);
        Assert.assertEquals((String)resourceMatch.getResourceAttributeDesignator().getAttributeId(), (String)this.expectedAttributeId);
        Assert.assertEquals((String)resourceMatch.getResourceAttributeDesignator().getDataType(), (String)this.expectedDataType);
        Assert.assertEquals((String)resourceMatch.getAttributeSelector().getDataType(), (String)this.expectedDataType);
        Assert.assertEquals((String)resourceMatch.getAttributeSelector().getRequestContextPath(), (String)this.expectedRequestContextPath);
    }

    @Test
    public void testChildElementsMarshall() {
        ResourceMatchType resourceMatch = new ResourceMatchTypeImplBuilder().buildObject();
        resourceMatch.setMatchId(this.expectedMatchId);
        AttributeValueType attributeValue = new AttributeValueTypeImplBuilder().buildObject();
        attributeValue.setDataType(this.expectedDataType);
        resourceMatch.setAttributeValue(attributeValue);
        AttributeDesignatorType attributeDesignator = (AttributeDesignatorType)this.buildXMLObject(AttributeDesignatorType.RESOURCE_ATTRIBUTE_DESIGNATOR_ELEMENT_NAME);
        attributeDesignator.setAttributeId(this.expectedAttributeId + "p");
        attributeDesignator.setDataType(this.expectedDataType + "*");
        attributeDesignator.setMustBePresent(Boolean.valueOf(true));
        resourceMatch.setResourceAttributeDesignator(attributeDesignator);
        attributeDesignator = (AttributeDesignatorType)this.buildXMLObject(AttributeDesignatorType.RESOURCE_ATTRIBUTE_DESIGNATOR_ELEMENT_NAME);
        attributeDesignator.setAttributeId(this.expectedAttributeId);
        attributeDesignator.setDataType(this.expectedDataType);
        attributeDesignator.setMustBePresent(null);
        resourceMatch.setResourceAttributeDesignator(attributeDesignator);
        AttributeSelectorType attributeSelector = new AttributeSelectorTypeImplBuilder().buildObject();
        attributeSelector.setDataType(this.expectedDataType + "7");
        attributeSelector.setRequestContextPath(this.expectedRequestContextPath + "7");
        attributeSelector.setMustBePresent(Boolean.valueOf(true));
        resourceMatch.setAttributeSelector(attributeSelector);
        attributeSelector = new AttributeSelectorTypeImplBuilder().buildObject();
        attributeSelector.setDataType(this.expectedDataType);
        attributeSelector.setRequestContextPath(this.expectedRequestContextPath);
        attributeSelector.setMustBePresentXSBoolean(null);
        resourceMatch.setAttributeSelector(attributeSelector);
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)resourceMatch);
    }
}

