/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.policy.SubjectAttributeDesignatorType;
import org.opensaml.xacml.policy.impl.SubjectAttributeDesignatorTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SubjectAttributeDesignatorTest
extends XMLObjectProviderBaseTestCase {
    private String expectedDataType;
    private String expectedAttributeId;
    private String expectedSubjectCategory;
    private String optionalIssuer;
    private Boolean optionalMustBePresent;

    public SubjectAttributeDesignatorTest() {
        this.singleElementFile = "/org/opensaml/xacml/policy/impl/SubjectAttributeDesignator.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/xacml/policy/impl/SubjectAttributeDesignatorOptionalAttributes.xml";
        this.expectedDataType = "https://example.org/Data/Type/Subject";
        this.expectedAttributeId = "https://example.org/Attribute/Id/Subject";
        this.expectedSubjectCategory = "CategoryForSubject";
        this.optionalIssuer = "TheIssuerSubject";
        this.optionalMustBePresent = true;
    }

    @Test
    public void testSingleElementUnmarshall() {
        SubjectAttributeDesignatorType attributeDesignator = (SubjectAttributeDesignatorType)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)attributeDesignator.getDataType(), (String)this.expectedDataType);
        Assert.assertEquals((String)attributeDesignator.getAttributeId(), (String)this.expectedAttributeId);
        Assert.assertEquals((String)attributeDesignator.getSubjectCategory(), (String)this.expectedSubjectCategory);
    }

    @Test
    public void testSingleElementMarshall() {
        SubjectAttributeDesignatorType attributeDesignator = new SubjectAttributeDesignatorTypeImplBuilder().buildObject();
        Assert.assertFalse((boolean)attributeDesignator.getMustBePresent());
        attributeDesignator.setDataType(this.expectedDataType);
        attributeDesignator.setAttributeId(this.expectedAttributeId);
        attributeDesignator.setSubjectCategory(this.expectedSubjectCategory);
        attributeDesignator.setMustBePresent(null);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)attributeDesignator);
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        SubjectAttributeDesignatorType attributeDesignator = (SubjectAttributeDesignatorType)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)attributeDesignator.getDataType(), (String)this.expectedDataType);
        Assert.assertEquals((String)attributeDesignator.getAttributeId(), (String)this.expectedAttributeId);
        Assert.assertEquals((Object)attributeDesignator.getMustBePresent(), (Object)this.optionalMustBePresent);
        Assert.assertEquals((String)attributeDesignator.getSubjectCategory(), (String)this.expectedSubjectCategory);
        Assert.assertEquals((String)attributeDesignator.getIssuer(), (String)this.optionalIssuer);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        SubjectAttributeDesignatorType attributeDesignator = new SubjectAttributeDesignatorTypeImplBuilder().buildObject();
        attributeDesignator.setDataType(this.expectedDataType);
        attributeDesignator.setAttributeId(this.expectedAttributeId);
        attributeDesignator.setMustBePresent(this.optionalMustBePresent);
        attributeDesignator.setSubjectCategory(this.expectedSubjectCategory);
        attributeDesignator.setIssuer(this.optionalIssuer);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)attributeDesignator);
    }
}

