/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.policy.ConditionType;
import org.opensaml.xacml.policy.ExpressionType;
import org.opensaml.xacml.policy.FunctionType;
import org.opensaml.xacml.policy.impl.ConditionTypeImplBuilder;
import org.opensaml.xacml.policy.impl.FunctionTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConditionTest
extends XMLObjectProviderBaseTestCase {
    private String expectedFunctionId;

    public ConditionTest() {
        this.singleElementFile = "/org/opensaml/xacml/policy/impl/Condition.xml";
        this.childElementsFile = "/org/opensaml/xacml/policy/impl/ConditionChildElements.xml";
        this.expectedFunctionId = "https://example.org/Condition/Function/Id";
    }

    @Test
    public void testSingleElementUnmarshall() {
        ConditionType condition = (ConditionType)this.unmarshallElement(this.singleElementFile);
        Assert.assertNull((Object)condition.getExpression());
    }

    @Test
    public void testSingleElementMarshall() {
        ConditionType condition = new ConditionTypeImplBuilder().buildObject();
        this.assertXMLEquals(this.expectedDOM, (XMLObject)condition);
    }

    @Test
    public void testChildElementsMarshall() {
        ConditionType condition = new ConditionTypeImplBuilder().buildObject();
        FunctionType func = new FunctionTypeImplBuilder().buildObject();
        func.setFunctionId(this.expectedFunctionId);
        condition.setExpression((ExpressionType)func);
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)condition);
    }

    @Test
    public void testChildElementsUnmarshall() {
        ConditionType condition = (ConditionType)this.unmarshallElement(this.childElementsFile);
        FunctionType func = (FunctionType)condition.getExpression();
        Assert.assertEquals((String)func.getFunctionId(), (String)this.expectedFunctionId);
    }
}

