/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.policy.EffectType;
import org.opensaml.xacml.policy.ObligationType;
import org.opensaml.xacml.policy.ObligationsType;
import org.opensaml.xacml.policy.impl.ObligationTypeImplBuilder;
import org.opensaml.xacml.policy.impl.ObligationsTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ObligationsTest
extends XMLObjectProviderBaseTestCase {
    private String expectedObligationId;
    private EffectType expectedFulFillOn;
    private int expectedObligations;

    public ObligationsTest() {
        this.singleElementFile = "/org/opensaml/xacml/policy/impl/Obligations.xml";
        this.childElementsFile = "/org/opensaml/xacml/policy/impl/ObligationsChildElements.xml";
        this.expectedObligationId = "http://example.org/Obligations/Id";
        this.expectedFulFillOn = EffectType.Permit;
        this.expectedObligations = 5;
    }

    @Test
    public void testSingleElementUnmarshall() {
        ObligationsType obligations = (ObligationsType)this.unmarshallElement(this.singleElementFile);
        Assert.assertTrue((boolean)obligations.getObligations().isEmpty());
    }

    @Test
    public void testSingleElementMarshall() {
        ObligationsType obligations = new ObligationsTypeImplBuilder().buildObject();
        this.assertXMLEquals(this.expectedDOM, (XMLObject)obligations);
    }

    @Test
    public void testChildElementsUnmarshall() {
        ObligationsType obligations = (ObligationsType)this.unmarshallElement(this.childElementsFile);
        for (ObligationType obligation : obligations.getObligations()) {
            Assert.assertEquals((String)obligation.getObligationId(), (String)this.expectedObligationId);
            Assert.assertEquals((Object)obligation.getFulfillOn(), (Object)this.expectedFulFillOn);
            Assert.assertTrue((boolean)obligation.getAttributeAssignments().isEmpty());
        }
    }

    @Test
    public void testChildElementsMarshall() {
        ObligationsType obligations = new ObligationsTypeImplBuilder().buildObject();
        ObligationTypeImplBuilder builder = new ObligationTypeImplBuilder();
        for (int i = 0; i < this.expectedObligations; ++i) {
            ObligationType obligation = builder.buildObject();
            obligation.setObligationId(this.expectedObligationId);
            obligation.setFulfillOn(this.expectedFulFillOn);
            obligations.getObligations().add(obligation);
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)obligations);
    }
}

