/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.policy.IdReferenceType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PolicyIdReferenceTest
extends XMLObjectProviderBaseTestCase {
    private String expectedReference;
    private String expectedVersion;
    private String expectedEarliestVersion;
    private String expectedLatestVersion;

    public PolicyIdReferenceTest() {
        this.singleElementFile = "/org/opensaml/xacml/policy/impl/PolicyIdReference.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/xacml/policy/impl/PolicyIdReferenceOptionalAttributes.xml";
        this.expectedReference = "https://example.org/Policy/Id/Reference";
        this.expectedVersion = "3.2.*";
        this.expectedEarliestVersion = "3.1.+";
        this.expectedLatestVersion = "3.3.99";
    }

    @Test
    public void testSingleElementUnmarshall() {
        IdReferenceType policyIdReference = (IdReferenceType)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)policyIdReference.getValue(), (String)this.expectedReference);
    }

    @Test
    public void testSingleElementMarshall() {
        IdReferenceType policyIdReference = (IdReferenceType)this.buildXMLObject(IdReferenceType.POLICY_ID_REFERENCE_ELEMENT_NAME);
        policyIdReference.setValue(this.expectedReference);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)policyIdReference);
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        IdReferenceType policyIdReference = (IdReferenceType)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)policyIdReference.getValue(), (String)this.expectedReference);
        Assert.assertEquals((String)policyIdReference.getVersion(), (String)this.expectedVersion);
        Assert.assertEquals((String)policyIdReference.getEarliestVersion(), (String)this.expectedEarliestVersion);
        Assert.assertEquals((String)policyIdReference.getLatestVersion(), (String)this.expectedLatestVersion);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        IdReferenceType policyIdReference = (IdReferenceType)this.buildXMLObject(IdReferenceType.POLICY_ID_REFERENCE_ELEMENT_NAME);
        policyIdReference.setValue(this.expectedReference);
        policyIdReference.setVersion(this.expectedVersion);
        policyIdReference.setEarliestVersion(this.expectedEarliestVersion);
        policyIdReference.setLatestVersion(this.expectedLatestVersion);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)policyIdReference);
    }
}

