/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.policy.ResourcesType;
import org.opensaml.xacml.policy.impl.ResourceTypeImplBuilder;
import org.opensaml.xacml.policy.impl.ResourcesTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ResourcesTest
extends XMLObjectProviderBaseTestCase {
    private int expectedResources;

    public ResourcesTest() {
        this.singleElementFile = "/org/opensaml/xacml/policy/impl/Resources.xml";
        this.childElementsFile = "/org/opensaml/xacml/policy/impl/ResourcesChildElements.xml";
        this.expectedResources = 6;
    }

    @Test
    public void testSingleElementUnmarshall() {
        ResourcesType resources = (ResourcesType)this.unmarshallElement(this.singleElementFile);
        Assert.assertTrue((boolean)resources.getResources().isEmpty());
    }

    @Test
    public void testSingleElementMarshall() {
        ResourcesType resources = new ResourcesTypeImplBuilder().buildObject();
        this.assertXMLEquals(this.expectedDOM, (XMLObject)resources);
    }

    @Test
    public void testChildElementsUnmarshall() {
        ResourcesType resources = (ResourcesType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)resources.getResources().size(), (int)this.expectedResources);
    }

    @Test
    public void testChildElementsMarshall() {
        ResourcesType resources = new ResourcesTypeImplBuilder().buildObject();
        ResourceTypeImplBuilder builder = new ResourceTypeImplBuilder();
        for (int i = 0; i < this.expectedResources; ++i) {
            resources.getResources().add(builder.buildObject());
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)resources);
    }
}

