/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.ctx.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xacml.ctx.AttributeValueType;
import org.opensaml.xacml.ctx.MissingAttributeDetailType;
import org.opensaml.xacml.ctx.impl.MissingAttributeDetailTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MissingAttributeDetailTest
extends XMLObjectProviderBaseTestCase {
    private String expectedAttributeId;
    private String expectedDataType;
    private String expectedIssuer;
    private int expectedNumAttributeValues;

    public MissingAttributeDetailTest() {
        this.singleElementFile = "/org/opensaml/xacml/ctx/impl/MissingAttributeDetail.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/xacml/ctx/impl/MissingAttributeDetailOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/xacml/ctx/impl/MissingAttributeDetailChildElements.xml";
        this.expectedAttributeId = "https://example.org/Missing/Attribute/Detail/Attribute/Id";
        this.expectedDataType = "https://example.org/Missing/Attribute/Detail/Data/Type";
        this.expectedIssuer = "MissingAttributeDetailIssuer";
        this.expectedNumAttributeValues = 5;
    }

    @Test
    public void testSingleElementUnmarshall() {
        MissingAttributeDetailType missingAttributeDetail = (MissingAttributeDetailType)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)missingAttributeDetail.getAttributeId(), (String)this.expectedAttributeId);
        Assert.assertEquals((String)missingAttributeDetail.getDataType(), (String)this.expectedDataType);
        Assert.assertNull((Object)missingAttributeDetail.getIssuer());
    }

    @Test
    public void testSingleElementMarshall() {
        MissingAttributeDetailType missingAttributeDetail = new MissingAttributeDetailTypeImplBuilder().buildObject();
        missingAttributeDetail.setAttributeId(this.expectedAttributeId);
        missingAttributeDetail.setDataType(this.expectedDataType);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)missingAttributeDetail);
    }

    @Test
    public void testChildElementsUnmarshall() {
        MissingAttributeDetailType missingAttributeDetail = (MissingAttributeDetailType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)missingAttributeDetail.getAttributeValues().size(), (int)this.expectedNumAttributeValues);
        Assert.assertEquals((String)missingAttributeDetail.getAttributeId(), (String)this.expectedAttributeId);
        Assert.assertEquals((String)missingAttributeDetail.getDataType(), (String)this.expectedDataType);
    }

    @Test
    public void testChildElementsMarshall() {
        MissingAttributeDetailType attribute = new MissingAttributeDetailTypeImplBuilder().buildObject();
        attribute.setAttributeId(this.expectedAttributeId);
        attribute.setDataType(this.expectedDataType);
        for (int i = 0; i < this.expectedNumAttributeValues; ++i) {
            attribute.getAttributeValues().add((AttributeValueType)this.buildXMLObject(AttributeValueType.DEFAULT_ELEMENT_NAME));
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)attribute);
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        MissingAttributeDetailType missingAttributeDetail = (MissingAttributeDetailType)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)missingAttributeDetail.getAttributeId(), (String)this.expectedAttributeId);
        Assert.assertEquals((String)missingAttributeDetail.getDataType(), (String)this.expectedDataType);
        Assert.assertEquals((String)missingAttributeDetail.getIssuer(), (String)this.expectedIssuer);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        MissingAttributeDetailType attribute = new MissingAttributeDetailTypeImplBuilder().buildObject();
        attribute.setAttributeId(this.expectedAttributeId);
        attribute.setDataType(this.expectedDataType);
        attribute.setIssuer(this.expectedIssuer);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)attribute);
    }
}

