/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xacml.policy.AttributeDesignatorType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ActionAttributeDesignatorTest
extends XMLObjectProviderBaseTestCase {
    private String expectedDataType;
    private String expectedAttributeId;
    private String optionalIssuer;
    private Boolean optionalMustBePresent;

    public ActionAttributeDesignatorTest() {
        this.singleElementFile = "/org/opensaml/xacml/policy/impl/ActionAttributeDesignator.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/xacml/policy/impl/ActionAttributeDesignatorOptionalAttributes.xml";
        this.expectedDataType = "https://example.org/Data/Type/Action";
        this.expectedAttributeId = "https://example.org/Attribute/Id/Action";
        this.optionalIssuer = "TheIssuerAction";
        this.optionalMustBePresent = true;
    }

    @Test
    public void testSingleElementUnmarshall() {
        AttributeDesignatorType attributeDesignator = (AttributeDesignatorType)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)attributeDesignator.getDataType(), (String)this.expectedDataType);
        Assert.assertEquals((String)attributeDesignator.getAttributeId(), (String)this.expectedAttributeId);
    }

    @Test
    public void testSingleElementMarshall() {
        AttributeDesignatorType attributeDesignator = (AttributeDesignatorType)this.buildXMLObject(AttributeDesignatorType.ACTION_ATTRIBUTE_DESIGNATOR_ELEMENT_NAME);
        attributeDesignator.setDataType(this.expectedDataType);
        attributeDesignator.setAttributeId(this.expectedAttributeId);
        attributeDesignator.setMustBePresent(null);
        Assert.assertFalse((boolean)attributeDesignator.getMustBePresent());
        this.assertXMLEquals(this.expectedDOM, (XMLObject)attributeDesignator);
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        AttributeDesignatorType attributeDesignator = (AttributeDesignatorType)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)attributeDesignator.getDataType(), (String)this.expectedDataType);
        Assert.assertEquals((String)attributeDesignator.getAttributeId(), (String)this.expectedAttributeId);
        Assert.assertEquals((Object)attributeDesignator.getMustBePresent(), (Object)this.optionalMustBePresent);
        Assert.assertEquals((String)attributeDesignator.getIssuer(), (String)this.optionalIssuer);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        AttributeDesignatorType attributeDesignator = (AttributeDesignatorType)this.buildXMLObject(AttributeDesignatorType.ACTION_ATTRIBUTE_DESIGNATOR_ELEMENT_NAME);
        attributeDesignator.setDataType(this.expectedDataType);
        attributeDesignator.setAttributeId(this.expectedAttributeId);
        attributeDesignator.setMustBePresent(this.optionalMustBePresent);
        attributeDesignator.setIssuer(this.optionalIssuer);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)attributeDesignator);
    }
}

