/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xacml.policy.DescriptionType;
import org.opensaml.xacml.policy.EffectType;
import org.opensaml.xacml.policy.RuleType;
import org.opensaml.xacml.policy.impl.ConditionTypeImplBuilder;
import org.opensaml.xacml.policy.impl.DescriptionTypeImplBuilder;
import org.opensaml.xacml.policy.impl.RuleTypeImplBuilder;
import org.opensaml.xacml.policy.impl.TargetTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RuleTest
extends XMLObjectProviderBaseTestCase {
    private String expectedRuleId;
    private String expectedDescription;

    public RuleTest() {
        this.singleElementFile = "/org/opensaml/xacml/policy/impl/Rule.xml";
        this.childElementsFile = "/org/opensaml/xacml/policy/impl/RuleChildElements.xml";
        this.expectedRuleId = "RuleRuleId";
        this.expectedDescription = "This is a Description";
    }

    @Test
    public void testSingleElementUnmarshall() {
        RuleType rule = (RuleType)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)rule.getRuleId(), (String)this.expectedRuleId);
        Assert.assertEquals((Object)rule.getEffect(), (Object)EffectType.Permit);
        Assert.assertNull((Object)rule.getDescription());
        Assert.assertNull((Object)rule.getTarget());
        Assert.assertNull((Object)rule.getCondition());
    }

    @Test
    public void testSingleElementMarshall() {
        RuleType rule = new RuleTypeImplBuilder().buildObject();
        rule.setRuleId(this.expectedRuleId);
        rule.setEffect(EffectType.Permit);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)rule);
    }

    @Test
    public void testChildElementsUnmarshall() {
        RuleType rule = (RuleType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((String)rule.getRuleId(), (String)this.expectedRuleId);
        Assert.assertEquals((Object)rule.getEffect(), (Object)EffectType.Deny);
        Assert.assertEquals((String)rule.getDescription().getValue(), (String)this.expectedDescription);
        Assert.assertNotNull((Object)rule.getTarget());
        Assert.assertNotNull((Object)rule.getCondition());
    }

    @Test
    public void testChildElementsMarshall() {
        RuleType rule = new RuleTypeImplBuilder().buildObject();
        rule.setRuleId(this.expectedRuleId);
        rule.setEffect(EffectType.Deny);
        DescriptionType description = new DescriptionTypeImplBuilder().buildObject();
        description.setValue(this.expectedDescription);
        rule.setDescription(description);
        rule.setTarget(new TargetTypeImplBuilder().buildObject());
        rule.setCondition(new ConditionTypeImplBuilder().buildObject());
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)rule);
    }
}

