/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xacml.policy.AttributeDesignatorType;
import org.opensaml.xacml.policy.AttributeSelectorType;
import org.opensaml.xacml.policy.AttributeValueType;
import org.opensaml.xacml.policy.SubjectMatchType;
import org.opensaml.xacml.policy.impl.AttributeSelectorTypeImplBuilder;
import org.opensaml.xacml.policy.impl.AttributeValueTypeImplBuilder;
import org.opensaml.xacml.policy.impl.SubjectMatchTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SubjectMatchTest
extends XMLObjectProviderBaseTestCase {
    private String expectedMatchId;
    private String expectedDataType;
    private String expectedAttributeId;
    private String expectedRequestContextPath;

    public SubjectMatchTest() {
        this.singleElementFile = "/org/opensaml/xacml/policy/impl/SubjectMatch.xml";
        this.childElementsFile = "/org/opensaml/xacml/policy/impl/SubjectMatchChildElements.xml";
        this.expectedMatchId = "http://example.org/Subject/Match/Match/Id";
        this.expectedDataType = "https://example.org/Subject/Match/Data/Type";
        this.expectedAttributeId = "https://example.org/Subject/Match/Attribute/Id";
        this.expectedRequestContextPath = "SubjectMatchAttrSelectConextPath";
    }

    @Test
    public void testSingleElementUnmarshall() {
        SubjectMatchType subjectMatch = (SubjectMatchType)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)subjectMatch.getMatchId(), (String)this.expectedMatchId);
        Assert.assertNull((Object)subjectMatch.getAttributeValue());
        Assert.assertNull((Object)subjectMatch.getSubjectAttributeDesignator());
        Assert.assertNull((Object)subjectMatch.getAttributeSelector());
    }

    @Test
    public void testSingleElementMarshall() {
        SubjectMatchType subjectMatch = new SubjectMatchTypeImplBuilder().buildObject();
        subjectMatch.setMatchId(this.expectedMatchId);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)subjectMatch);
    }

    @Test
    public void testChildElementsUnmarshall() {
        SubjectMatchType subjectMatch = (SubjectMatchType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((String)subjectMatch.getMatchId(), (String)this.expectedMatchId);
        Assert.assertEquals((String)subjectMatch.getAttributeValue().getDataType(), (String)this.expectedDataType);
        Assert.assertEquals((String)subjectMatch.getSubjectAttributeDesignator().getAttributeId(), (String)this.expectedAttributeId);
        Assert.assertEquals((String)subjectMatch.getSubjectAttributeDesignator().getDataType(), (String)this.expectedDataType);
        Assert.assertEquals((String)subjectMatch.getAttributeSelector().getDataType(), (String)this.expectedDataType);
        Assert.assertEquals((String)subjectMatch.getAttributeSelector().getRequestContextPath(), (String)this.expectedRequestContextPath);
    }

    @Test
    public void testChildElementsMarshall() {
        SubjectMatchType subjectMatch = new SubjectMatchTypeImplBuilder().buildObject();
        subjectMatch.setMatchId(this.expectedMatchId);
        AttributeValueType attributeValue = new AttributeValueTypeImplBuilder().buildObject();
        attributeValue.setDataType(this.expectedDataType);
        subjectMatch.setAttributeValue(attributeValue);
        AttributeDesignatorType attributeDesignator = (AttributeDesignatorType)this.buildXMLObject(AttributeDesignatorType.SUBJECT_ATTRIBUTE_DESIGNATOR_ELEMENT_NAME);
        attributeDesignator.setAttributeId(this.expectedAttributeId + "*");
        attributeDesignator.setDataType(this.expectedDataType + "*");
        attributeDesignator.setMustBePresent(null);
        subjectMatch.setSubjectAttributeDesignator(attributeDesignator);
        attributeDesignator = (AttributeDesignatorType)this.buildXMLObject(AttributeDesignatorType.SUBJECT_ATTRIBUTE_DESIGNATOR_ELEMENT_NAME);
        attributeDesignator.setAttributeId(this.expectedAttributeId);
        attributeDesignator.setDataType(this.expectedDataType);
        attributeDesignator.setMustBePresent(null);
        subjectMatch.setSubjectAttributeDesignator(attributeDesignator);
        AttributeSelectorType attributeSelector = new AttributeSelectorTypeImplBuilder().buildObject();
        attributeSelector.setDataType(this.expectedDataType + "*");
        attributeSelector.setRequestContextPath("*" + this.expectedRequestContextPath);
        attributeSelector.setMustBePresentXSBoolean(null);
        subjectMatch.setAttributeSelector(attributeSelector);
        attributeSelector = new AttributeSelectorTypeImplBuilder().buildObject();
        attributeSelector.setDataType(this.expectedDataType);
        attributeSelector.setRequestContextPath(this.expectedRequestContextPath);
        attributeSelector.setMustBePresentXSBoolean(null);
        subjectMatch.setAttributeSelector(attributeSelector);
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)subjectMatch);
    }
}

