/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.support;

import java.security.Key;
import java.security.KeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Collections;
import javax.crypto.SecretKey;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.encryption.support.DataEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.Decrypter;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.Encrypter;
import org.opensaml.xmlsec.encryption.support.EncryptionException;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.KeyEncryptionParameters;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.mock.SignableSimpleXMLObject;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class SimpleDecryptionTest
extends XMLObjectBaseTestCase {
    private KeyInfoCredentialResolver keyResolver;
    private KeyInfoCredentialResolver kekResolver;
    private String encURI = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    private Key encKey;
    private DataEncryptionParameters encParams;
    private EncryptedData encryptedData;
    private EncryptedData encryptedContent;
    private String kekURI = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    private KeyEncryptionParameters kekParams;
    private EncryptedKey encryptedKey;
    private String targetFile = "/data/org/opensaml/xmlsec/encryption/support/SimpleDecryptionTest.xml";
    private Document targetDOM;
    private SignableSimpleXMLObject targetObject;

    @BeforeMethod
    protected void setUp() throws Exception {
        Credential encCred = AlgorithmSupport.generateSymmetricKeyAndCredential((String)this.encURI);
        this.encKey = encCred.getSecretKey();
        this.keyResolver = new StaticKeyInfoCredentialResolver(encCred);
        this.encParams = new DataEncryptionParameters();
        this.encParams.setAlgorithm(this.encURI);
        this.encParams.setEncryptionCredential(encCred);
        Credential kekCred = AlgorithmSupport.generateKeyPairAndCredential((String)this.kekURI, (int)1024, (boolean)true);
        this.kekResolver = new StaticKeyInfoCredentialResolver(kekCred);
        this.kekParams = new KeyEncryptionParameters();
        this.kekParams.setAlgorithm(this.kekURI);
        this.kekParams.setEncryptionCredential(kekCred);
        Encrypter encrypter = new Encrypter();
        this.encryptedKey = encrypter.encryptKey(this.encKey, this.kekParams, parserPool.newDocument());
        this.targetDOM = parserPool.parse(SimpleDecryptionTest.class.getResourceAsStream(this.targetFile));
        this.targetObject = (SignableSimpleXMLObject)this.unmarshallElement(this.targetFile);
        try {
            this.encryptedData = encrypter.encryptElement((XMLObject)this.targetObject, this.encParams);
            this.encryptedContent = encrypter.encryptElementContent((XMLObject)this.targetObject, this.encParams);
        }
        catch (EncryptionException e) {
            Assert.fail((String)("Object encryption failed: " + (Object)((Object)e)));
        }
    }

    @Test
    public void testEncryptedKey() {
        Decrypter decrypter = new Decrypter(null, this.kekResolver, null);
        Key decryptedKey = null;
        try {
            decryptedKey = decrypter.decryptKey(this.encryptedKey, this.encURI);
        }
        catch (DecryptionException e) {
            Assert.fail((String)("Error on decryption of EncryptedKey: " + (Object)((Object)e)));
        }
        Assert.assertEquals((Object)this.encKey, (Object)decryptedKey, (String)"Decrypted EncryptedKey");
    }

    @Test
    public void testEncryptedElement() {
        Decrypter decrypter = new Decrypter(this.keyResolver, null, null);
        XMLObject decryptedXMLObject = null;
        try {
            decryptedXMLObject = decrypter.decryptData(this.encryptedData);
        }
        catch (DecryptionException e) {
            Assert.fail((String)("Error on decryption of EncryptedData to element: " + (Object)((Object)e)));
        }
        this.assertXMLEquals(this.targetDOM, decryptedXMLObject);
    }

    @Test(expectedExceptions={DecryptionException.class})
    public void testEncryptedDataAlgorithmBlacklistFail() throws DecryptionException {
        Decrypter decrypter = new Decrypter(this.keyResolver, null, null, null, Collections.singleton(this.encURI));
        decrypter.decryptData(this.encryptedData);
    }

    @Test(expectedExceptions={DecryptionException.class})
    public void testEncryptedDataAlgorithmWhitelistFail() throws DecryptionException {
        Decrypter decrypter = new Decrypter(this.keyResolver, null, null, Collections.singleton("urn-x:some:bogus:algo"), null);
        decrypter.decryptData(this.encryptedData);
    }

    @Test
    public void testEncryptedDataAlgorithmWhitelistPass() throws DecryptionException {
        Decrypter decrypter = new Decrypter(this.keyResolver, null, null, Collections.singleton(this.encURI), null);
        decrypter.decryptData(this.encryptedData);
    }

    @Test(expectedExceptions={DecryptionException.class})
    public void testEncryptedKeyAlgorithmBlacklistFail() throws DecryptionException {
        Decrypter decrypter = new Decrypter(null, this.kekResolver, null, null, Collections.singleton(this.kekURI));
        decrypter.decryptKey(this.encryptedKey, this.encURI);
    }

    @Test(expectedExceptions={DecryptionException.class})
    public void testEncryptedKeyAlgorithmWhitelistFail() throws DecryptionException {
        Decrypter decrypter = new Decrypter(null, this.kekResolver, null, Collections.singleton("urn-x:some:bogus:algo"), null);
        decrypter.decryptKey(this.encryptedKey, this.encURI);
    }

    @Test
    public void testEncryptedKeyAlgorithmWhitelistPass() throws DecryptionException {
        Decrypter decrypter = new Decrypter(null, this.kekResolver, null, Collections.singleton(this.kekURI), null);
        decrypter.decryptKey(this.encryptedKey, this.encURI);
    }

    @Test
    public void testEncryptedElementWithEncryptedKeyInline() {
        KeyInfo keyInfo = (KeyInfo)this.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
        keyInfo.getEncryptedKeys().add(this.encryptedKey);
        this.encryptedData.setKeyInfo(keyInfo);
        InlineEncryptedKeyResolver ekr = new InlineEncryptedKeyResolver();
        Decrypter decrypter = new Decrypter(null, this.kekResolver, (EncryptedKeyResolver)ekr);
        XMLObject decryptedXMLObject = null;
        try {
            decryptedXMLObject = decrypter.decryptData(this.encryptedData);
        }
        catch (DecryptionException e) {
            Assert.fail((String)("Error on decryption of EncryptedData to element: " + (Object)((Object)e)));
        }
        this.assertXMLEquals(this.targetDOM, decryptedXMLObject);
    }

    @Test
    public void testErrorNoResolvers() {
        Decrypter decrypter = new Decrypter(null, null, null);
        try {
            decrypter.decryptData(this.encryptedData);
            Assert.fail((String)"Decryption should have failed, no resolvers configured");
        }
        catch (DecryptionException decryptionException) {
            // empty catch block
        }
    }

    @Test
    public void testErrorInvalidDataDecryptionKey() throws NoSuchAlgorithmException, NoSuchProviderException, KeyException {
        SecretKey badKey = AlgorithmSupport.generateSymmetricKey((String)this.encURI);
        BasicCredential encCred = new BasicCredential(badKey);
        StaticKeyInfoCredentialResolver badEncResolver = new StaticKeyInfoCredentialResolver((Credential)encCred);
        Decrypter decrypter = new Decrypter((KeyInfoCredentialResolver)badEncResolver, null, null);
        try {
            decrypter.decryptData(this.encryptedData);
            Assert.fail((String)"Decryption should have failed, invalid data decryption key");
        }
        catch (DecryptionException e) {
            // empty catch block
        }
    }

    @Test
    public void testErrorInvalidKeyDecryptionKey() throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPair badKeyPair = AlgorithmSupport.generateKeyPair((String)this.kekURI, (int)1024);
        BasicCredential kekCred = new BasicCredential(badKeyPair.getPublic(), badKeyPair.getPrivate());
        StaticKeyInfoCredentialResolver badKEKResolver = new StaticKeyInfoCredentialResolver((Credential)kekCred);
        Decrypter decrypter = new Decrypter(null, (KeyInfoCredentialResolver)badKEKResolver, null);
        try {
            decrypter.decryptKey(this.encryptedKey, this.encURI);
            Assert.fail((String)"Decryption should have failed, invalid key decryption key");
        }
        catch (DecryptionException e) {
            // empty catch block
        }
    }

    @Test
    public void testEncryptedContent() {
        Decrypter decrypter = new Decrypter(this.keyResolver, null, null);
        try {
            decrypter.decryptData(this.encryptedContent);
            Assert.fail((String)"This should have failed, decryption of element content not yet supported");
        }
        catch (DecryptionException e) {
            Assert.assertTrue((boolean)true, (String)"Decryption of element content not yet supported");
        }
    }
}

