/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.support;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.SimpleKeyInfoReferenceEncryptedKeyResolver;
import org.opensaml.xmlsec.mock.SignableSimpleXMLObject;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.KeyInfoReference;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SimpleKeyInfoReferenceEncryptedKeyResolverTest
extends XMLObjectBaseTestCase {
    private SimpleKeyInfoReferenceEncryptedKeyResolver resolver;

    @Test
    public void testSingleEKNoRecipient() {
        String filename = "/data/org/opensaml/xmlsec/encryption/support/SimpleKeyInfoReferenceEncryptedKeyResolverSingle.xml";
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)this.unmarshallElement(filename);
        Assert.assertNotNull((Object)((Object)sxo));
        Assert.assertNotNull((Object)((Object)sxo.getSimpleXMLObjects().get(0)));
        Assert.assertNotNull((Object)sxo.getSimpleXMLObjects().get(0).getEncryptedData());
        EncryptedData encData = sxo.getSimpleXMLObjects().get(0).getEncryptedData();
        Assert.assertNotNull((Object)encData.getKeyInfo());
        Assert.assertFalse((boolean)encData.getKeyInfo().getXMLObjects(KeyInfoReference.DEFAULT_ELEMENT_NAME).isEmpty());
        List<EncryptedKey> allKeys = this.getEncryptedKeys(sxo);
        Assert.assertFalse((boolean)allKeys.isEmpty());
        this.resolver = new SimpleKeyInfoReferenceEncryptedKeyResolver();
        List<EncryptedKey> resolved = this.generateList(encData, (EncryptedKeyResolver)this.resolver);
        Assert.assertEquals((int)resolved.size(), (int)1, (String)"Incorrect number of resolved EncryptedKeys found");
        Assert.assertTrue((resolved.get(0) == allKeys.get(0) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
    }

    @Test
    public void testSingleEKWithRecipient() {
        String filename = "/data/org/opensaml/xmlsec/encryption/support/SimpleKeyInfoReferenceEncryptedKeyResolverSingle.xml";
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)this.unmarshallElement(filename);
        Assert.assertNotNull((Object)((Object)sxo));
        Assert.assertNotNull((Object)((Object)sxo.getSimpleXMLObjects().get(0)));
        Assert.assertNotNull((Object)sxo.getSimpleXMLObjects().get(0).getEncryptedData());
        EncryptedData encData = sxo.getSimpleXMLObjects().get(0).getEncryptedData();
        Assert.assertNotNull((Object)encData.getKeyInfo());
        Assert.assertFalse((boolean)encData.getKeyInfo().getXMLObjects(KeyInfoReference.DEFAULT_ELEMENT_NAME).isEmpty());
        List<EncryptedKey> allKeys = this.getEncryptedKeys(sxo);
        Assert.assertFalse((boolean)allKeys.isEmpty());
        this.resolver = new SimpleKeyInfoReferenceEncryptedKeyResolver((Set)Sets.newHashSet((Object[])new String[]{"foo"}));
        List<EncryptedKey> resolved = this.generateList(encData, (EncryptedKeyResolver)this.resolver);
        Assert.assertEquals((int)resolved.size(), (int)1, (String)"Incorrect number of resolved EncryptedKeys found");
        Assert.assertTrue((resolved.get(0) == allKeys.get(0) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
    }

    @Test
    public void testMultiEKWithOneRecipient() {
        String filename = "/data/org/opensaml/xmlsec/encryption/support/SimpleKeyInfoReferenceEncryptedKeyResolverMultiple.xml";
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)this.unmarshallElement(filename);
        Assert.assertNotNull((Object)((Object)sxo));
        Assert.assertNotNull((Object)((Object)sxo.getSimpleXMLObjects().get(0)));
        Assert.assertNotNull((Object)sxo.getSimpleXMLObjects().get(0).getEncryptedData());
        EncryptedData encData = sxo.getSimpleXMLObjects().get(0).getEncryptedData();
        Assert.assertNotNull((Object)encData.getKeyInfo());
        Assert.assertFalse((boolean)encData.getKeyInfo().getKeyInfoReferences().isEmpty());
        List<EncryptedKey> allKeys = this.getEncryptedKeys(sxo);
        Assert.assertFalse((boolean)allKeys.isEmpty());
        this.resolver = new SimpleKeyInfoReferenceEncryptedKeyResolver((Set)Sets.newHashSet((Object[])new String[]{"foo"}));
        List<EncryptedKey> resolved = this.generateList(encData, (EncryptedKeyResolver)this.resolver);
        Assert.assertEquals((int)resolved.size(), (int)1, (String)"Incorrect number of resolved EncryptedKeys found");
        Assert.assertTrue((resolved.get(0) == allKeys.get(0) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
    }

    @Test
    public void testMultiEKWithTwoRecipients() {
        String filename = "/data/org/opensaml/xmlsec/encryption/support/SimpleKeyInfoReferenceEncryptedKeyResolverMultiple.xml";
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)this.unmarshallElement(filename);
        Assert.assertNotNull((Object)((Object)sxo));
        Assert.assertNotNull((Object)((Object)sxo.getSimpleXMLObjects().get(0)));
        Assert.assertNotNull((Object)sxo.getSimpleXMLObjects().get(0).getEncryptedData());
        EncryptedData encData = sxo.getSimpleXMLObjects().get(0).getEncryptedData();
        Assert.assertNotNull((Object)encData.getKeyInfo());
        Assert.assertFalse((boolean)encData.getKeyInfo().getKeyInfoReferences().isEmpty());
        List<EncryptedKey> allKeys = this.getEncryptedKeys(sxo);
        Assert.assertFalse((boolean)allKeys.isEmpty());
        this.resolver = new SimpleKeyInfoReferenceEncryptedKeyResolver((Set)Sets.newHashSet((Object[])new String[]{"foo", "baz"}));
        List<EncryptedKey> resolved = this.generateList(encData, (EncryptedKeyResolver)this.resolver);
        Assert.assertEquals((int)resolved.size(), (int)2, (String)"Incorrect number of resolved EncryptedKeys found");
        Assert.assertTrue((resolved.get(0) == allKeys.get(0) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
        Assert.assertTrue((resolved.get(1) == allKeys.get(2) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
    }

    private List<EncryptedKey> getEncryptedKeys(SignableSimpleXMLObject sxo) {
        ArrayList<EncryptedKey> allKeys = new ArrayList<EncryptedKey>();
        for (XMLObject xmlObject : sxo.getUnknownXMLObjects()) {
            if (!(xmlObject instanceof KeyInfo)) continue;
            allKeys.addAll(((KeyInfo)xmlObject).getEncryptedKeys());
        }
        return allKeys;
    }

    private List<EncryptedKey> generateList(EncryptedData encData, EncryptedKeyResolver ekResolver) {
        ArrayList<EncryptedKey> resolved = new ArrayList<EncryptedKey>();
        for (EncryptedKey encKey : ekResolver.resolve(encData)) {
            resolved.add(encKey);
        }
        return resolved;
    }
}

