/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.xmlsec.DecryptionConfiguration;
import org.opensaml.xmlsec.DecryptionParameters;
import org.opensaml.xmlsec.criterion.DecryptionConfigurationCriterion;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.opensaml.xmlsec.impl.BasicDecryptionConfiguration;
import org.opensaml.xmlsec.impl.BasicDecryptionParametersResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BasicDecryptionParametersResolverTest {
    private BasicDecryptionParametersResolver resolver;
    private CriteriaSet criteriaSet;
    private DecryptionConfigurationCriterion criterion;
    private BasicDecryptionConfiguration config1;
    private BasicDecryptionConfiguration config2;
    private BasicDecryptionConfiguration config3;
    private KeyInfoCredentialResolver controlKeyInfoResolver1;
    private KeyInfoCredentialResolver controlKeyInfoResolver2;
    private KeyInfoCredentialResolver controlKeyInfoResolver3;
    private EncryptedKeyResolver controlEncKeyResolver1;
    private EncryptedKeyResolver controlEncKeyResolver2;
    private EncryptedKeyResolver controlEncKeyResolver3;

    @BeforeClass
    public void buildResolvers() {
        this.controlKeyInfoResolver1 = new StaticKeyInfoCredentialResolver(new ArrayList());
        this.controlKeyInfoResolver2 = new StaticKeyInfoCredentialResolver(new ArrayList());
        this.controlKeyInfoResolver3 = new StaticKeyInfoCredentialResolver(new ArrayList());
        this.controlEncKeyResolver1 = new InlineEncryptedKeyResolver();
        this.controlEncKeyResolver2 = new InlineEncryptedKeyResolver();
        this.controlEncKeyResolver3 = new InlineEncryptedKeyResolver();
    }

    @BeforeMethod
    public void setUp() {
        this.resolver = new BasicDecryptionParametersResolver();
        this.config1 = new BasicDecryptionConfiguration();
        this.config2 = new BasicDecryptionConfiguration();
        this.config3 = new BasicDecryptionConfiguration();
        this.criterion = new DecryptionConfigurationCriterion(new DecryptionConfiguration[]{this.config1, this.config2, this.config3});
        this.criteriaSet = new CriteriaSet(new Criterion[]{this.criterion});
    }

    @Test
    public void testResolveDataKeyInfoCredentialResolver() throws ResolverException {
        KeyInfoCredentialResolver kiResolver = this.resolver.resolveDataKeyInfoCredentialResolver(this.criteriaSet);
        Assert.assertNull((Object)kiResolver);
        this.config1.setDataKeyInfoCredentialResolver(this.controlKeyInfoResolver1);
        this.config2.setDataKeyInfoCredentialResolver(this.controlKeyInfoResolver2);
        this.config3.setDataKeyInfoCredentialResolver(this.controlKeyInfoResolver3);
        kiResolver = this.resolver.resolveDataKeyInfoCredentialResolver(this.criteriaSet);
        Assert.assertTrue((kiResolver == this.controlKeyInfoResolver1 ? 1 : 0) != 0);
        this.config1.setDataKeyInfoCredentialResolver(null);
        kiResolver = this.resolver.resolveDataKeyInfoCredentialResolver(this.criteriaSet);
        Assert.assertTrue((kiResolver == this.controlKeyInfoResolver2 ? 1 : 0) != 0);
        this.config2.setDataKeyInfoCredentialResolver(null);
        kiResolver = this.resolver.resolveDataKeyInfoCredentialResolver(this.criteriaSet);
        Assert.assertTrue((kiResolver == this.controlKeyInfoResolver3 ? 1 : 0) != 0);
    }

    @Test
    public void testResolveKEKKeyInfoCredentialResolver() throws ResolverException {
        KeyInfoCredentialResolver kiResolver = this.resolver.resolveKEKKeyInfoCredentialResolver(this.criteriaSet);
        Assert.assertNull((Object)kiResolver);
        this.config1.setKEKKeyInfoCredentialResolver(this.controlKeyInfoResolver1);
        this.config2.setKEKKeyInfoCredentialResolver(this.controlKeyInfoResolver2);
        this.config3.setKEKKeyInfoCredentialResolver(this.controlKeyInfoResolver3);
        kiResolver = this.resolver.resolveKEKKeyInfoCredentialResolver(this.criteriaSet);
        Assert.assertTrue((kiResolver == this.controlKeyInfoResolver1 ? 1 : 0) != 0);
        this.config1.setKEKKeyInfoCredentialResolver(null);
        kiResolver = this.resolver.resolveKEKKeyInfoCredentialResolver(this.criteriaSet);
        Assert.assertTrue((kiResolver == this.controlKeyInfoResolver2 ? 1 : 0) != 0);
        this.config2.setKEKKeyInfoCredentialResolver(null);
        kiResolver = this.resolver.resolveKEKKeyInfoCredentialResolver(this.criteriaSet);
        Assert.assertTrue((kiResolver == this.controlKeyInfoResolver3 ? 1 : 0) != 0);
    }

    @Test
    public void testResolveEncryptedKeyResolver() throws ResolverException {
        EncryptedKeyResolver encKeyResolver = this.resolver.resolveEncryptedKeyResolver(this.criteriaSet);
        Assert.assertNull((Object)encKeyResolver);
        this.config1.setEncryptedKeyResolver(this.controlEncKeyResolver1);
        this.config2.setEncryptedKeyResolver(this.controlEncKeyResolver2);
        this.config3.setEncryptedKeyResolver(this.controlEncKeyResolver3);
        encKeyResolver = this.resolver.resolveEncryptedKeyResolver(this.criteriaSet);
        Assert.assertTrue((encKeyResolver == this.controlEncKeyResolver1 ? 1 : 0) != 0);
        this.config1.setEncryptedKeyResolver(null);
        encKeyResolver = this.resolver.resolveEncryptedKeyResolver(this.criteriaSet);
        Assert.assertTrue((encKeyResolver == this.controlEncKeyResolver2 ? 1 : 0) != 0);
        this.config2.setEncryptedKeyResolver(null);
        encKeyResolver = this.resolver.resolveEncryptedKeyResolver(this.criteriaSet);
        Assert.assertTrue((encKeyResolver == this.controlEncKeyResolver3 ? 1 : 0) != 0);
    }

    @Test
    public void testResolve() throws ResolverException {
        this.config1.setBlacklistedAlgorithms((Collection)Sets.newHashSet((Object[])new String[]{"foo", "bar"}));
        this.config1.setDataKeyInfoCredentialResolver(this.controlKeyInfoResolver1);
        this.config1.setKEKKeyInfoCredentialResolver(this.controlKeyInfoResolver1);
        this.config1.setEncryptedKeyResolver(this.controlEncKeyResolver1);
        Iterable paramsIter = this.resolver.resolve(this.criteriaSet);
        Assert.assertNotNull((Object)paramsIter);
        Iterator iterator = paramsIter.iterator();
        Assert.assertNotNull(iterator);
        Assert.assertTrue((boolean)iterator.hasNext());
        DecryptionParameters params = (DecryptionParameters)iterator.next();
        Assert.assertNotNull((Object)params);
        Assert.assertTrue((params.getDataKeyInfoCredentialResolver() == this.controlKeyInfoResolver1 ? 1 : 0) != 0);
        Assert.assertTrue((params.getKEKKeyInfoCredentialResolver() == this.controlKeyInfoResolver1 ? 1 : 0) != 0);
        Assert.assertTrue((params.getEncryptedKeyResolver() == this.controlEncKeyResolver1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)params.getWhitelistedAlgorithms().isEmpty());
        Assert.assertEquals((int)params.getBlacklistedAlgorithms().size(), (int)2);
        Assert.assertTrue((boolean)params.getBlacklistedAlgorithms().contains("foo"));
        Assert.assertTrue((boolean)params.getBlacklistedAlgorithms().contains("bar"));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testResolveSingle() throws ResolverException {
        this.config1.setBlacklistedAlgorithms((Collection)Sets.newHashSet((Object[])new String[]{"foo", "bar"}));
        this.config1.setDataKeyInfoCredentialResolver(this.controlKeyInfoResolver1);
        this.config1.setKEKKeyInfoCredentialResolver(this.controlKeyInfoResolver1);
        this.config1.setEncryptedKeyResolver(this.controlEncKeyResolver1);
        DecryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertTrue((params.getDataKeyInfoCredentialResolver() == this.controlKeyInfoResolver1 ? 1 : 0) != 0);
        Assert.assertTrue((params.getKEKKeyInfoCredentialResolver() == this.controlKeyInfoResolver1 ? 1 : 0) != 0);
        Assert.assertTrue((params.getEncryptedKeyResolver() == this.controlEncKeyResolver1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)params.getWhitelistedAlgorithms().isEmpty());
        Assert.assertEquals((int)params.getBlacklistedAlgorithms().size(), (int)2);
        Assert.assertTrue((boolean)params.getBlacklistedAlgorithms().contains("foo"));
        Assert.assertTrue((boolean)params.getBlacklistedAlgorithms().contains("bar"));
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullCriteriaSet() throws ResolverException {
        this.resolver.resolve(null);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testAbsentCriterion() throws ResolverException {
        this.resolver.resolve(new CriteriaSet());
    }
}

