/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.WhitelistBlacklistConfiguration;
import org.opensaml.xmlsec.WhitelistBlacklistParameters;
import org.opensaml.xmlsec.impl.AbstractSecurityParametersResolver;
import org.opensaml.xmlsec.impl.BasicWhitelistBlacklistConfiguration;
import org.opensaml.xmlsec.impl.WhitelistBlacklistConfigurationCriterion;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.NamedKeyInfoGeneratorManager;
import org.opensaml.xmlsec.keyinfo.impl.BasicKeyInfoGeneratorFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AbstractSecurityParametersResolverTest
extends XMLObjectBaseTestCase {
    private WhitelistBlacklistParametersResolver resolver;
    private BasicWhitelistBlacklistConfiguration config1;
    private BasicWhitelistBlacklistConfiguration config2;
    private BasicWhitelistBlacklistConfiguration config3;
    private WhitelistBlacklistConfigurationCriterion criterion;
    private CriteriaSet criteriaSet;
    private Set<String> set1;
    private Set<String> set2;
    private Set<String> set3;

    @BeforeMethod
    public void setUp() {
        this.resolver = new WhitelistBlacklistParametersResolver();
        this.config1 = new BasicWhitelistBlacklistConfiguration();
        this.config2 = new BasicWhitelistBlacklistConfiguration();
        this.config3 = new BasicWhitelistBlacklistConfiguration();
        this.criterion = new WhitelistBlacklistConfigurationCriterion(new WhitelistBlacklistConfiguration[]{this.config1, this.config2, this.config3});
        this.criteriaSet = new CriteriaSet(new Criterion[]{this.criterion});
        this.set1 = Sets.newHashSet((Object[])new String[]{"A", "B", "C", "D"});
        this.set2 = Sets.newHashSet((Object[])new String[]{"X", "Y", "Z"});
        this.set3 = Sets.newHashSet((Object[])new String[]{"foo", "bar", "baz"});
    }

    @Test
    public void testBlacklistOnlyDefaults() throws ResolverException {
        this.config1.setBlacklistedAlgorithms(this.set1);
        this.config2.setBlacklistedAlgorithms(this.set2);
        WhitelistBlacklistParameters params = this.resolver.resolveSingle(this.criteriaSet);
        HashSet<String> control = new HashSet<String>();
        control.addAll(this.set1);
        control.addAll(this.set2);
        Assert.assertEquals((Collection)params.getWhitelistedAlgorithms(), Collections.emptySet());
        Assert.assertEquals((Collection)params.getBlacklistedAlgorithms(), control);
    }

    @Test
    public void testBlacklistOnlyNoMerge() throws ResolverException {
        this.config1.setBlacklistedAlgorithms(this.set1);
        this.config1.setBlacklistMerge(false);
        this.config2.setBlacklistedAlgorithms(this.set2);
        WhitelistBlacklistParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertEquals((Collection)params.getWhitelistedAlgorithms(), Collections.emptySet());
        Assert.assertEquals((Collection)params.getBlacklistedAlgorithms(), this.set1);
    }

    @Test
    public void testBlacklistOnlyWithSimpleMerge() throws ResolverException {
        this.config1.setBlacklistedAlgorithms(this.set1);
        this.config1.setBlacklistMerge(true);
        this.config2.setBlacklistedAlgorithms(this.set2);
        WhitelistBlacklistParameters params = this.resolver.resolveSingle(this.criteriaSet);
        HashSet<String> control = new HashSet<String>();
        control.addAll(this.set1);
        control.addAll(this.set2);
        Assert.assertEquals((Collection)params.getWhitelistedAlgorithms(), Collections.emptySet());
        Assert.assertEquals((Collection)params.getBlacklistedAlgorithms(), control);
    }

    @Test
    public void testBlacklistOnlyWithTransitiveMerge() throws ResolverException {
        this.config1.setBlacklistedAlgorithms(this.set1);
        this.config1.setBlacklistMerge(true);
        this.config2.setBlacklistMerge(true);
        this.config3.setBlacklistedAlgorithms(this.set3);
        WhitelistBlacklistParameters params = this.resolver.resolveSingle(this.criteriaSet);
        HashSet<String> control = new HashSet<String>();
        control.addAll(this.set1);
        control.addAll(this.set3);
        Assert.assertEquals((Collection)params.getWhitelistedAlgorithms(), Collections.emptySet());
        Assert.assertEquals((Collection)params.getBlacklistedAlgorithms(), control);
    }

    @Test
    public void testWhitelistOnlyDefaults() throws ResolverException {
        this.config1.setWhitelistedAlgorithms(this.set1);
        this.config2.setWhitelistedAlgorithms(this.set2);
        WhitelistBlacklistParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertEquals((Collection)params.getWhitelistedAlgorithms(), this.set1);
        Assert.assertEquals((Collection)params.getBlacklistedAlgorithms(), Collections.emptySet());
    }

    @Test
    public void testWhitelistOnlyWithSimpleMerge() throws ResolverException {
        this.config1.setWhitelistedAlgorithms(this.set1);
        this.config1.setWhitelistMerge(true);
        this.config2.setWhitelistedAlgorithms(this.set2);
        WhitelistBlacklistParameters params = this.resolver.resolveSingle(this.criteriaSet);
        HashSet<String> control = new HashSet<String>();
        control.addAll(this.set1);
        control.addAll(this.set2);
        Assert.assertEquals((Collection)params.getWhitelistedAlgorithms(), control);
        Assert.assertEquals((Collection)params.getBlacklistedAlgorithms(), Collections.emptySet());
    }

    @Test
    public void testWhitelistOnlyWithTransitiveMerge() throws ResolverException {
        this.config1.setWhitelistedAlgorithms(this.set1);
        this.config1.setWhitelistMerge(true);
        this.config2.setWhitelistMerge(true);
        this.config3.setWhitelistedAlgorithms(this.set3);
        WhitelistBlacklistParameters params = this.resolver.resolveSingle(this.criteriaSet);
        HashSet<String> control = new HashSet<String>();
        control.addAll(this.set1);
        control.addAll(this.set3);
        Assert.assertEquals((Collection)params.getWhitelistedAlgorithms(), control);
        Assert.assertEquals((Collection)params.getBlacklistedAlgorithms(), Collections.emptySet());
    }

    @Test
    public void testPrecedence() throws ResolverException {
        this.config1.setWhitelistedAlgorithms(this.set1);
        this.config1.setBlacklistedAlgorithms(this.set2);
        this.config1.setWhitelistBlacklistPrecedence(WhitelistBlacklistConfiguration.Precedence.WHITELIST);
        WhitelistBlacklistParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertEquals((Collection)params.getWhitelistedAlgorithms(), this.set1);
        Assert.assertEquals((Collection)params.getBlacklistedAlgorithms(), Collections.emptySet());
        this.config1.setWhitelistBlacklistPrecedence(WhitelistBlacklistConfiguration.Precedence.BLACKLIST);
        params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertEquals((Collection)params.getWhitelistedAlgorithms(), Collections.emptySet());
        Assert.assertEquals((Collection)params.getBlacklistedAlgorithms(), this.set2);
    }

    @Test
    public void testResolvePredicate() {
        this.config1.setWhitelistedAlgorithms(this.set1);
        this.config1.setBlacklistedAlgorithms(this.set2);
        this.config1.setWhitelistBlacklistPrecedence(WhitelistBlacklistConfiguration.Precedence.WHITELIST);
        Predicate predicate = this.resolver.resolveWhitelistBlacklistPredicate(this.criteriaSet, Lists.newArrayList((Object[])new BasicWhitelistBlacklistConfiguration[]{this.config1, this.config2, this.config3}));
        Assert.assertTrue((boolean)predicate.apply((Object)"A"));
        Assert.assertTrue((boolean)predicate.apply((Object)"B"));
        Assert.assertTrue((boolean)predicate.apply((Object)"C"));
        Assert.assertTrue((boolean)predicate.apply((Object)"D"));
        Assert.assertFalse((boolean)predicate.apply((Object)"X"));
        Assert.assertFalse((boolean)predicate.apply((Object)"Y"));
        Assert.assertFalse((boolean)predicate.apply((Object)"Z"));
        Assert.assertFalse((boolean)predicate.apply((Object)"foo"));
        Assert.assertFalse((boolean)predicate.apply((Object)"bar"));
        Assert.assertFalse((boolean)predicate.apply((Object)"bax"));
        this.config1.setWhitelistBlacklistPrecedence(WhitelistBlacklistConfiguration.Precedence.BLACKLIST);
        predicate = this.resolver.resolveWhitelistBlacklistPredicate(this.criteriaSet, Lists.newArrayList((Object[])new BasicWhitelistBlacklistConfiguration[]{this.config1, this.config2, this.config3}));
        Assert.assertTrue((boolean)predicate.apply((Object)"A"));
        Assert.assertTrue((boolean)predicate.apply((Object)"B"));
        Assert.assertTrue((boolean)predicate.apply((Object)"C"));
        Assert.assertTrue((boolean)predicate.apply((Object)"D"));
        Assert.assertTrue((boolean)predicate.apply((Object)"foo"));
        Assert.assertTrue((boolean)predicate.apply((Object)"bar"));
        Assert.assertTrue((boolean)predicate.apply((Object)"bax"));
        Assert.assertFalse((boolean)predicate.apply((Object)"X"));
        Assert.assertFalse((boolean)predicate.apply((Object)"Y"));
        Assert.assertFalse((boolean)predicate.apply((Object)"Z"));
    }

    @Test
    public void testResolveEffectiveWhitelist() {
        Collection whitelist = this.resolver.resolveEffectiveWhitelist(this.criteriaSet, this.criterion.getConfigurations());
        Assert.assertTrue((boolean)whitelist.isEmpty());
        this.config1.setWhitelistedAlgorithms(this.set1);
        this.config2.setWhitelistedAlgorithms(this.set2);
        this.config3.setWhitelistedAlgorithms(this.set3);
        whitelist = this.resolver.resolveEffectiveWhitelist(this.criteriaSet, this.criterion.getConfigurations());
        Assert.assertTrue((boolean)whitelist.containsAll(this.set1));
        Assert.assertFalse((boolean)whitelist.containsAll(this.set2));
        Assert.assertFalse((boolean)whitelist.containsAll(this.set3));
        this.config1.setWhitelistMerge(true);
        whitelist = this.resolver.resolveEffectiveWhitelist(this.criteriaSet, this.criterion.getConfigurations());
        Assert.assertTrue((boolean)whitelist.containsAll(this.set1));
        Assert.assertTrue((boolean)whitelist.containsAll(this.set2));
        Assert.assertFalse((boolean)whitelist.containsAll(this.set3));
        this.config1.setWhitelistMerge(true);
        this.config2.setWhitelistMerge(true);
        whitelist = this.resolver.resolveEffectiveWhitelist(this.criteriaSet, this.criterion.getConfigurations());
        Assert.assertTrue((boolean)whitelist.containsAll(this.set1));
        Assert.assertTrue((boolean)whitelist.containsAll(this.set2));
        Assert.assertTrue((boolean)whitelist.containsAll(this.set3));
        this.config1.setWhitelistedAlgorithms(new HashSet());
        this.config2.setWhitelistedAlgorithms(new HashSet());
        this.config1.setWhitelistMerge(true);
        this.config2.setWhitelistMerge(true);
        whitelist = this.resolver.resolveEffectiveWhitelist(this.criteriaSet, this.criterion.getConfigurations());
        Assert.assertFalse((boolean)whitelist.containsAll(this.set1));
        Assert.assertFalse((boolean)whitelist.containsAll(this.set2));
        Assert.assertTrue((boolean)whitelist.containsAll(this.set3));
    }

    @Test
    public void testResolveEffectiveBlacklist() {
        Collection blacklist = this.resolver.resolveEffectiveBlacklist(this.criteriaSet, this.criterion.getConfigurations());
        Assert.assertTrue((boolean)blacklist.isEmpty());
        this.config1.setBlacklistedAlgorithms(this.set1);
        this.config2.setBlacklistedAlgorithms(this.set2);
        this.config3.setBlacklistedAlgorithms(this.set3);
        blacklist = this.resolver.resolveEffectiveBlacklist(this.criteriaSet, this.criterion.getConfigurations());
        Assert.assertTrue((boolean)blacklist.containsAll(this.set1));
        Assert.assertTrue((boolean)blacklist.containsAll(this.set2));
        Assert.assertTrue((boolean)blacklist.containsAll(this.set3));
        this.config2.setBlacklistMerge(false);
        blacklist = this.resolver.resolveEffectiveBlacklist(this.criteriaSet, this.criterion.getConfigurations());
        Assert.assertTrue((boolean)blacklist.containsAll(this.set1));
        Assert.assertTrue((boolean)blacklist.containsAll(this.set2));
        Assert.assertFalse((boolean)blacklist.containsAll(this.set3));
        this.config1.setBlacklistMerge(false);
        this.config2.setBlacklistMerge(false);
        blacklist = this.resolver.resolveEffectiveBlacklist(this.criteriaSet, this.criterion.getConfigurations());
        Assert.assertTrue((boolean)blacklist.containsAll(this.set1));
        Assert.assertFalse((boolean)blacklist.containsAll(this.set2));
        Assert.assertFalse((boolean)blacklist.containsAll(this.set3));
        this.config1.setBlacklistedAlgorithms(new HashSet());
        this.config2.setBlacklistedAlgorithms(new HashSet());
        this.config1.setBlacklistMerge(true);
        this.config2.setBlacklistMerge(true);
        blacklist = this.resolver.resolveEffectiveBlacklist(this.criteriaSet, this.criterion.getConfigurations());
        Assert.assertFalse((boolean)blacklist.containsAll(this.set1));
        Assert.assertFalse((boolean)blacklist.containsAll(this.set2));
        Assert.assertTrue((boolean)blacklist.containsAll(this.set3));
    }

    @Test
    public void testResolveEffectivePrecedence() {
        this.config1.setWhitelistBlacklistPrecedence(WhitelistBlacklistConfiguration.Precedence.WHITELIST);
        WhitelistBlacklistConfiguration.Precedence precedence = this.resolver.resolveWhitelistBlacklistPrecedence(this.criteriaSet, this.criterion.getConfigurations());
        Assert.assertEquals((Object)precedence, (Object)WhitelistBlacklistConfiguration.Precedence.WHITELIST);
        this.config1.setWhitelistBlacklistPrecedence(WhitelistBlacklistConfiguration.Precedence.BLACKLIST);
        precedence = this.resolver.resolveWhitelistBlacklistPrecedence(this.criteriaSet, this.criterion.getConfigurations());
        Assert.assertEquals((Object)precedence, (Object)WhitelistBlacklistConfiguration.Precedence.BLACKLIST);
    }

    @Test
    public void testKeyInfoGeneratorLookup() throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPair kp = KeySupport.generateKeyPair((String)"RSA", (int)2048, null);
        BasicCredential cred = CredentialSupport.getSimpleCredential((PublicKey)kp.getPublic(), (PrivateKey)kp.getPrivate());
        NamedKeyInfoGeneratorManager manager = new NamedKeyInfoGeneratorManager();
        manager.setUseDefaultManager(false);
        manager.registerDefaultFactory((KeyInfoGeneratorFactory)new BasicKeyInfoGeneratorFactory());
        Assert.assertNotNull((Object)this.resolver.lookupKeyInfoGenerator((Credential)cred, manager, null));
        Assert.assertNull((Object)this.resolver.lookupKeyInfoGenerator((Credential)cred, manager, "test"));
        manager = new NamedKeyInfoGeneratorManager();
        manager.setUseDefaultManager(true);
        manager.registerDefaultFactory((KeyInfoGeneratorFactory)new BasicKeyInfoGeneratorFactory());
        Assert.assertNotNull((Object)this.resolver.lookupKeyInfoGenerator((Credential)cred, manager, null));
        Assert.assertNotNull((Object)this.resolver.lookupKeyInfoGenerator((Credential)cred, manager, "test"));
        manager = new NamedKeyInfoGeneratorManager();
        manager.registerFactory("test", (KeyInfoGeneratorFactory)new BasicKeyInfoGeneratorFactory());
        Assert.assertNull((Object)this.resolver.lookupKeyInfoGenerator((Credential)cred, manager, null));
        Assert.assertNotNull((Object)this.resolver.lookupKeyInfoGenerator((Credential)cred, manager, "test"));
        Assert.assertNull((Object)this.resolver.lookupKeyInfoGenerator((Credential)cred, null, null));
        Assert.assertNull((Object)this.resolver.lookupKeyInfoGenerator((Credential)cred, null, "test"));
        try {
            this.resolver.lookupKeyInfoGenerator(null, manager, "test");
            Assert.fail((String)"Null credential should have thrown");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
    }

    public class WhitelistBlacklistParametersResolver
    extends AbstractSecurityParametersResolver<WhitelistBlacklistParameters> {
        @Nonnull
        public Iterable<WhitelistBlacklistParameters> resolve(CriteriaSet criteria) throws ResolverException {
            WhitelistBlacklistParameters params = this.resolveSingle(criteria);
            if (params != null) {
                return Collections.singletonList(params);
            }
            return Collections.emptyList();
        }

        @Nullable
        public WhitelistBlacklistParameters resolveSingle(CriteriaSet criteria) throws ResolverException {
            WhitelistBlacklistParameters params = new WhitelistBlacklistParameters();
            this.resolveAndPopulateWhiteAndBlacklists(params, criteria, ((WhitelistBlacklistConfigurationCriterion)criteria.get(WhitelistBlacklistConfigurationCriterion.class)).getConfigurations());
            return params;
        }
    }
}

