/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import com.google.common.collect.Lists;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.List;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.impl.BasicSignatureSigningConfiguration;
import org.opensaml.xmlsec.keyinfo.NamedKeyInfoGeneratorManager;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BasicSignatureSigningConfigurationTest {
    private BasicSignatureSigningConfiguration config;
    private Credential cred1;
    private Credential cred2;

    @BeforeClass
    public void generateCredentials() throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPair kp1 = KeySupport.generateKeyPair((String)"RSA", (int)2048, null);
        this.cred1 = CredentialSupport.getSimpleCredential((PublicKey)kp1.getPublic(), (PrivateKey)kp1.getPrivate());
        KeyPair kp2 = KeySupport.generateKeyPair((String)"RSA", (int)2048, null);
        this.cred2 = CredentialSupport.getSimpleCredential((PublicKey)kp2.getPublic(), (PrivateKey)kp2.getPrivate());
    }

    @BeforeMethod
    public void setUp() {
        this.config = new BasicSignatureSigningConfiguration();
    }

    @Test
    public void testDefaults() {
        Assert.assertNotNull((Object)this.config.getSigningCredentials());
        Assert.assertTrue((boolean)this.config.getSigningCredentials().isEmpty());
        Assert.assertNotNull((Object)this.config.getSignatureAlgorithms());
        Assert.assertTrue((boolean)this.config.getSignatureAlgorithms().isEmpty());
        Assert.assertNotNull((Object)this.config.getSignatureReferenceDigestMethods());
        Assert.assertTrue((boolean)this.config.getSignatureReferenceDigestMethods().isEmpty());
        Assert.assertNull((Object)this.config.getSignatureCanonicalizationAlgorithm());
        Assert.assertNull((Object)this.config.getSignatureHMACOutputLength());
        Assert.assertNull((Object)this.config.getKeyInfoGeneratorManager());
    }

    @Test
    public void testSigningCredentials() throws NoSuchAlgorithmException, NoSuchProviderException {
        Assert.assertNotNull((Object)this.config.getSigningCredentials());
        Assert.assertEquals((int)this.config.getSigningCredentials().size(), (int)0);
        this.config.setSigningCredentials((List)Lists.newArrayList((Object[])new Credential[]{this.cred1, null, this.cred2, null}));
        Assert.assertNotNull((Object)this.config.getSigningCredentials());
        Assert.assertEquals((int)this.config.getSigningCredentials().size(), (int)2);
        this.config.setSigningCredentials(null);
        Assert.assertNotNull((Object)this.config.getSigningCredentials());
        Assert.assertEquals((int)this.config.getSigningCredentials().size(), (int)0);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testSigningCredentialsImmutable() throws NoSuchAlgorithmException, NoSuchProviderException {
        this.config.setSigningCredentials((List)Lists.newArrayList((Object[])new Credential[]{this.cred1}));
        this.config.getSigningCredentials().add(this.cred2);
    }

    @Test
    public void testSignatureAlgorithmURIs() {
        Assert.assertNotNull((Object)this.config.getSignatureAlgorithms());
        Assert.assertEquals((int)this.config.getSignatureAlgorithms().size(), (int)0);
        this.config.setSignatureAlgorithms((List)Lists.newArrayList((Object[])new String[]{"  A   ", null, null, "  B   ", null, "  C   "}));
        Assert.assertNotNull((Object)this.config.getSignatureAlgorithms());
        Assert.assertEquals((int)this.config.getSignatureAlgorithms().size(), (int)3);
        Assert.assertEquals((String)((String)this.config.getSignatureAlgorithms().get(0)), (String)"A");
        Assert.assertEquals((String)((String)this.config.getSignatureAlgorithms().get(1)), (String)"B");
        Assert.assertEquals((String)((String)this.config.getSignatureAlgorithms().get(2)), (String)"C");
        this.config.setSignatureAlgorithms(null);
        Assert.assertNotNull((Object)this.config.getSignatureAlgorithms());
        Assert.assertEquals((int)this.config.getSignatureAlgorithms().size(), (int)0);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testSignatureAlgorithmURIsImmutable() {
        this.config.setSignatureAlgorithms((List)Lists.newArrayList((Object[])new String[]{"A", "B", "C"}));
        this.config.getSignatureAlgorithms().add("D");
    }

    @Test
    public void testSignatureReferenceDigestMethods() {
        Assert.assertNotNull((Object)this.config.getSignatureReferenceDigestMethods());
        Assert.assertEquals((int)this.config.getSignatureReferenceDigestMethods().size(), (int)0);
        this.config.setSignatureReferenceDigestMethods((List)Lists.newArrayList((Object[])new String[]{"   A  ", null, null, "   B   ", null, "  C    "}));
        Assert.assertNotNull((Object)this.config.getSignatureReferenceDigestMethods());
        Assert.assertEquals((int)this.config.getSignatureReferenceDigestMethods().size(), (int)3);
        Assert.assertEquals((String)((String)this.config.getSignatureReferenceDigestMethods().get(0)), (String)"A");
        Assert.assertEquals((String)((String)this.config.getSignatureReferenceDigestMethods().get(1)), (String)"B");
        Assert.assertEquals((String)((String)this.config.getSignatureReferenceDigestMethods().get(2)), (String)"C");
        this.config.setSignatureReferenceDigestMethods(null);
        Assert.assertNotNull((Object)this.config.getSignatureReferenceDigestMethods());
        Assert.assertEquals((int)this.config.getSignatureReferenceDigestMethods().size(), (int)0);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testSignatureReferenceDigestMethodsImmutable() {
        this.config.setSignatureReferenceDigestMethods((List)Lists.newArrayList((Object[])new String[]{"A", "B", "C"}));
        this.config.getSignatureReferenceDigestMethods().add("D");
    }

    @Test
    public void testSignatureCanonicalizationAlgorithm() {
        Assert.assertNull((Object)this.config.getSignatureCanonicalizationAlgorithm());
        this.config.setSignatureCanonicalizationAlgorithm("   foo   ");
        Assert.assertEquals((String)this.config.getSignatureCanonicalizationAlgorithm(), (String)"foo");
        this.config.setSignatureCanonicalizationAlgorithm("    ");
        Assert.assertNull((Object)this.config.getSignatureCanonicalizationAlgorithm());
        this.config.setSignatureCanonicalizationAlgorithm(null);
        Assert.assertNull((Object)this.config.getSignatureCanonicalizationAlgorithm());
    }

    @Test
    public void testSignatureHMACOutputLength() {
        Assert.assertNull((Object)this.config.getSignatureHMACOutputLength());
        this.config.setSignatureHMACOutputLength(Integer.valueOf(128));
        Assert.assertEquals((Object)this.config.getSignatureHMACOutputLength(), (Object)new Integer(128));
        this.config.setSignatureHMACOutputLength(null);
        Assert.assertNull((Object)this.config.getSignatureHMACOutputLength());
    }

    @Test
    public void testKeyInfoGeneratorManager() {
        Assert.assertNull((Object)this.config.getKeyInfoGeneratorManager());
        this.config.setKeyInfoGeneratorManager(new NamedKeyInfoGeneratorManager());
        Assert.assertNotNull((Object)this.config.getKeyInfoGeneratorManager());
        this.config.setKeyInfoGeneratorManager(null);
        Assert.assertNull((Object)this.config.getKeyInfoGeneratorManager());
    }
}

