/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.keyinfo.impl;

import java.security.KeyException;
import java.security.PublicKey;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.security.SecurityException;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoGenerator;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.KeyName;
import org.opensaml.xmlsec.signature.KeyValue;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

public class StaticKeyInfoGeneratorTest
extends XMLObjectBaseTestCase {
    private StaticKeyInfoGenerator generator;
    private KeyInfo origKeyInfo;
    private String expectedKeyName1 = "Foo";
    private String expectedKeyName2 = "Bar";
    private String expectedKeyAlgorithm = "RSA";
    private PublicKey expectedKeyValue;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.origKeyInfo = (KeyInfo)this.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
        KeyName keyname1 = (KeyName)this.buildXMLObject(KeyName.DEFAULT_ELEMENT_NAME);
        keyname1.setValue(this.expectedKeyName1);
        this.origKeyInfo.getKeyNames().add(keyname1);
        KeyName keyname2 = (KeyName)this.buildXMLObject(KeyName.DEFAULT_ELEMENT_NAME);
        keyname2.setValue(this.expectedKeyName2);
        this.origKeyInfo.getKeyNames().add(keyname2);
        this.expectedKeyValue = KeySupport.generateKeyPair((String)this.expectedKeyAlgorithm, (int)1024, null).getPublic();
        KeyInfoSupport.addPublicKey((KeyInfo)this.origKeyInfo, (PublicKey)this.expectedKeyValue);
        this.generator = new StaticKeyInfoGenerator(this.origKeyInfo);
    }

    @Test
    public void testSimple() throws SecurityException, KeyException {
        Assert.assertNull((Object)this.origKeyInfo.getParent(), (String)"Original KeyInfo should NOT have parent");
        KeyInfo keyInfo = this.generator.generate(null);
        this.checkKeyInfo(keyInfo);
        Assert.assertTrue((this.origKeyInfo == keyInfo ? 1 : 0) != 0, (String)"KeyInfo instances were not the same");
        keyInfo = this.generator.generate(null);
        this.checkKeyInfo(keyInfo);
        Assert.assertTrue((this.origKeyInfo == keyInfo ? 1 : 0) != 0, (String)"KeyInfo instances were not the same");
        keyInfo = this.generator.generate(null);
        this.checkKeyInfo(keyInfo);
        Assert.assertTrue((this.origKeyInfo == keyInfo ? 1 : 0) != 0, (String)"KeyInfo instances were not the same");
    }

    @Test
    public void testWithCloningNoDOMCache() throws SecurityException, KeyException {
        EncryptedData encData = (EncryptedData)this.buildXMLObject(EncryptedData.DEFAULT_ELEMENT_NAME);
        Assert.assertNull((Object)this.origKeyInfo.getDOM(), (String)"Original KeyInfo should not have a cached DOM");
        KeyInfo keyInfo = this.generator.generate(null);
        this.checkKeyInfo(keyInfo);
        Assert.assertTrue((this.origKeyInfo == keyInfo ? 1 : 0) != 0, (String)"KeyInfo instances were not the same");
        encData.setKeyInfo(this.origKeyInfo);
        Assert.assertNotNull((Object)this.origKeyInfo.getParent(), (String)"Original KeyInfo should have parent");
        keyInfo = this.generator.generate(null);
        this.checkKeyInfo(keyInfo);
        Assert.assertFalse((this.origKeyInfo == keyInfo ? 1 : 0) != 0, (String)"KeyInfo instances should have differed due to cloning");
        Assert.assertNotNull((Object)keyInfo.getDOM(), (String)"Generated KeyInfo should have a cached DOM");
        Assert.assertNull((Object)this.origKeyInfo.getDOM(), (String)"Original KeyInfo marshalled DOM should have been cleared after cloning");
    }

    @Test
    public void testWithCloningWithDOMCache() throws SecurityException, KeyException, MarshallingException {
        EncryptedData encData = (EncryptedData)this.buildXMLObject(EncryptedData.DEFAULT_ELEMENT_NAME);
        XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)this.origKeyInfo).marshall((XMLObject)this.origKeyInfo);
        Assert.assertNotNull((Object)this.origKeyInfo.getDOM(), (String)"Original KeyInfo should have a cached DOM");
        Element origDOM = this.origKeyInfo.getDOM();
        KeyInfo keyInfo = this.generator.generate(null);
        this.checkKeyInfo(keyInfo);
        Assert.assertTrue((this.origKeyInfo == keyInfo ? 1 : 0) != 0, (String)"KeyInfo instances were not the same");
        encData.setKeyInfo(this.origKeyInfo);
        Assert.assertNotNull((Object)this.origKeyInfo.getParent(), (String)"Original KeyInfo should have parent");
        keyInfo = this.generator.generate(null);
        this.checkKeyInfo(keyInfo);
        Assert.assertFalse((this.origKeyInfo == keyInfo ? 1 : 0) != 0, (String)"KeyInfo instances should have differed due to cloning");
        Assert.assertNull((Object)keyInfo.getDOM(), (String)"Generated KeyInfo should NOT have a cached DOM");
        Assert.assertNotNull((Object)this.origKeyInfo.getDOM(), (String)"KeyInfo cached DOM should NOT have been cleared after cloning");
        Assert.assertTrue((boolean)origDOM.isSameNode(this.origKeyInfo.getDOM()), (String)"DOM Elements were not the same");
    }

    private void checkKeyInfo(KeyInfo keyInfo) throws KeyException {
        Assert.assertNotNull((Object)keyInfo, (String)"KeyInfo was null");
        Assert.assertEquals((int)keyInfo.getKeyNames().size(), (int)2, (String)"Number of KeyNames");
        Assert.assertEquals((String)((KeyName)keyInfo.getKeyNames().get(0)).getValue(), (String)this.expectedKeyName1, (String)"Unexpected value for KeyName");
        Assert.assertEquals((String)((KeyName)keyInfo.getKeyNames().get(1)).getValue(), (String)this.expectedKeyName2, (String)"Unexpected value for KeyName");
        Assert.assertEquals((int)keyInfo.getKeyValues().size(), (int)1, (String)"Number of KeyValues");
        PublicKey pubKey = KeyInfoSupport.getKey((KeyValue)((KeyValue)keyInfo.getKeyValues().get(0)));
        Assert.assertEquals((Object)pubKey, (Object)this.expectedKeyValue, (String)"Unexpected public key value");
    }
}

