/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xmlsec.signature.X509Digest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class X509DigestTest
extends XMLObjectProviderBaseTestCase {
    private String expectedAlgorithm;
    private String expectedStringContent;

    public X509DigestTest() {
        this.singleElementFile = "/data/org/opensaml/xmlsec/signature/impl/X509Digest.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedAlgorithm = "http://www.w3.org/2000/09/xmldsig#sha1";
        this.expectedStringContent = "someX509Digest";
    }

    @Test
    public void testSingleElementUnmarshall() {
        X509Digest digest = (X509Digest)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)digest, (String)"X509Digest");
        Assert.assertEquals((String)this.expectedAlgorithm, (String)digest.getAlgorithm(), (String)"Algorithm attribute");
        Assert.assertEquals((String)digest.getValue(), (String)this.expectedStringContent, (String)"X509Digest value");
    }

    @Test
    public void testSingleElementMarshall() {
        X509Digest digest = (X509Digest)this.buildXMLObject(X509Digest.DEFAULT_ELEMENT_NAME);
        digest.setValue(this.expectedStringContent);
        digest.setAlgorithm(this.expectedAlgorithm);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)digest);
    }
}

