/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.support;

import java.io.InputStream;
import java.util.List;
import javax.crypto.SecretKey;
import javax.xml.bind.ValidationException;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.mock.SignableSimpleXMLObject;
import org.opensaml.xmlsec.mock.SignableSimpleXMLObjectBuilder;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.KeyName;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.impl.KeyInfoBuilder;
import org.opensaml.xmlsec.signature.impl.SignatureBuilder;
import org.opensaml.xmlsec.signature.impl.SignatureImpl;
import org.opensaml.xmlsec.signature.support.DocumentInternalIDContentReference;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.opensaml.xmlsec.signature.support.Signer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HMACSignatureTest
extends XMLObjectBaseTestCase {
    private final Logger log = LoggerFactory.getLogger(HMACSignatureTest.class);
    private Credential goodCredential;
    private Credential badCredential;
    private SignableSimpleXMLObjectBuilder sxoBuilder;
    private SignatureBuilder sigBuilder;
    private KeyInfoBuilder keyInfoBuilder;
    private Integer hmacOutputLength;
    private String expectedKeyName;
    private String algoURI = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";

    @BeforeMethod
    protected void setUp() throws Exception {
        this.hmacOutputLength = new Integer(160);
        this.expectedKeyName = "KeyFoo123";
        SecretKey key = KeySupport.generateKey((String)"AES", (int)128, null);
        this.goodCredential = CredentialSupport.getSimpleCredential((SecretKey)key);
        key = KeySupport.generateKey((String)"AES", (int)128, null);
        this.badCredential = CredentialSupport.getSimpleCredential((SecretKey)key);
        this.sxoBuilder = new SignableSimpleXMLObjectBuilder();
        this.sigBuilder = new SignatureBuilder();
        this.keyInfoBuilder = new KeyInfoBuilder();
    }

    @Test
    public void testSigningAndVerificationNoOutputLength() throws MarshallingException, ValidationException, SignatureException {
        SignableSimpleXMLObject sxo = this.getXMLObjectWithSignature(false);
        Signature signature = sxo.getSignature();
        Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)sxo);
        Element signedElement = marshaller.marshall((XMLObject)sxo);
        Signer.signObject((Signature)signature);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Marshalled Signature: \n" + SerializeSupport.nodeToString((Node)signedElement));
        }
        SignatureValidator.validate((Signature)signature, (Credential)this.goodCredential);
        try {
            SignatureValidator.validate((Signature)signature, (Credential)this.badCredential);
            Assert.fail((String)"Validated signature with invalid secret key");
        }
        catch (SignatureException e) {
            // empty catch block
        }
    }

    @Test
    public void testSigningAndVerificationWithOutputLength() throws MarshallingException, SignatureException {
        SignableSimpleXMLObject sxo = this.getXMLObjectWithSignature(true);
        Signature signature = sxo.getSignature();
        Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)sxo);
        Element signedElement = marshaller.marshall((XMLObject)sxo);
        Signer.signObject((Signature)signature);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Marshalled Signature: \n" + SerializeSupport.nodeToString((Node)signedElement));
        }
        SignatureValidator.validate((Signature)signature, (Credential)this.goodCredential);
        try {
            SignatureValidator.validate((Signature)signature, (Credential)this.badCredential);
            Assert.fail((String)"Validated signature with invalid secret key");
        }
        catch (SignatureException e) {
            // empty catch block
        }
    }

    @Test
    public void testUnmarshallNoOutputLength() throws XMLParserException, UnmarshallingException {
        String envelopedSignatureFile = "/data/org/opensaml/xmlsec/signature/support/HMACSignatureNoOutputLength.xml";
        InputStream ins = HMACSignatureTest.class.getResourceAsStream(envelopedSignatureFile);
        Document envelopedSignatureDoc = parserPool.parse(ins);
        Element rootElement = envelopedSignatureDoc.getDocumentElement();
        Unmarshaller unmarshaller = XMLObjectProviderRegistrySupport.getUnmarshallerFactory().getUnmarshaller(rootElement);
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)unmarshaller.unmarshall(rootElement);
        Assert.assertEquals((String)sxo.getId(), (String)"FOO", (String)"Id attribute was not expected value");
        Signature signature = sxo.getSignature();
        Assert.assertNotNull((Object)signature, (String)"Signature was null");
        KeyInfo keyInfo = signature.getKeyInfo();
        Assert.assertNotNull((Object)keyInfo, (String)"Signature's KeyInfo was null");
        KeyName keyName = (KeyName)keyInfo.getKeyNames().get(0);
        Assert.assertNotNull((Object)keyName, (String)"KeyName was null");
        String keyNameValue = StringSupport.trimOrNull((String)keyName.getValue());
        Assert.assertNotNull((Object)keyNameValue, (String)"KeyName value was empty");
        Assert.assertNull((Object)signature.getHMACOutputLength(), (String)"HMACOutputLength value was not null");
    }

    @Test
    public void testUnmarshallWithOutputLength() throws XMLParserException, UnmarshallingException {
        String envelopedSignatureFile = "/data/org/opensaml/xmlsec/signature/support/HMACSignatureWithOutputLength.xml";
        InputStream ins = HMACSignatureTest.class.getResourceAsStream(envelopedSignatureFile);
        Document envelopedSignatureDoc = parserPool.parse(ins);
        Element rootElement = envelopedSignatureDoc.getDocumentElement();
        Unmarshaller unmarshaller = XMLObjectProviderRegistrySupport.getUnmarshallerFactory().getUnmarshaller(rootElement);
        SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)unmarshaller.unmarshall(rootElement);
        Assert.assertEquals((String)sxo.getId(), (String)"FOO", (String)"Id attribute was not expected value");
        Signature signature = sxo.getSignature();
        Assert.assertNotNull((Object)signature, (String)"Signature was null");
        KeyInfo keyInfo = signature.getKeyInfo();
        Assert.assertNotNull((Object)keyInfo, (String)"Signature's KeyInfo was null");
        KeyName keyName = (KeyName)keyInfo.getKeyNames().get(0);
        Assert.assertNotNull((Object)keyName, (String)"KeyName was null");
        String keyNameValue = StringSupport.trimOrNull((String)keyName.getValue());
        Assert.assertNotNull((Object)keyNameValue, (String)"KeyName value was empty");
        Assert.assertNotNull((Object)signature.getHMACOutputLength(), (String)"HMACOutputLength value was null");
        Assert.assertEquals((Object)signature.getHMACOutputLength(), (Object)this.hmacOutputLength, (String)"HMACOutputLength value was incorrect value");
    }

    @Test
    public void testMarshallNoOutputLength() throws MarshallingException {
        SignableSimpleXMLObject sxo = this.getXMLObjectWithSignature(false);
        Signature signature = sxo.getSignature();
        Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)sxo);
        marshaller.marshall((XMLObject)sxo);
        Assert.assertNotNull((Object)signature.getDOM(), (String)"Signature DOM was null");
        XMLSignature apacheSignature = ((SignatureImpl)signature).getXMLSignature();
        Assert.assertNotNull((Object)apacheSignature, (String)"Apache XMLSignature was null");
        SignedInfo apacheSignedInfo = apacheSignature.getSignedInfo();
        Assert.assertNotNull((Object)apacheSignedInfo, (String)"Apache SignedInfo was null");
        Element sigMethodElement = apacheSignedInfo.getSignatureMethodElement();
        List children = ElementSupport.getChildElementsByTagNameNS((Node)sigMethodElement, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"HMACOutputLength");
        Assert.assertTrue((boolean)children.isEmpty(), (String)"Signature method should not have HMACOutputLength child");
    }

    @Test
    public void testMarshallWithOutputLength() throws MarshallingException {
        SignableSimpleXMLObject sxo = this.getXMLObjectWithSignature(true);
        Signature signature = sxo.getSignature();
        Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)sxo);
        marshaller.marshall((XMLObject)sxo);
        Assert.assertNotNull((Object)signature.getDOM(), (String)"Signature DOM was null");
        XMLSignature apacheSignature = ((SignatureImpl)signature).getXMLSignature();
        Assert.assertNotNull((Object)apacheSignature, (String)"Apache XMLSignature was null");
        SignedInfo apacheSignedInfo = apacheSignature.getSignedInfo();
        Assert.assertNotNull((Object)apacheSignedInfo, (String)"Apache SignedInfo was null");
        Element sigMethodElement = apacheSignedInfo.getSignatureMethodElement();
        List children = ElementSupport.getChildElementsByTagNameNS((Node)sigMethodElement, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"HMACOutputLength");
        Assert.assertFalse((boolean)children.isEmpty(), (String)"Signature method should have HMACOutputLength child");
        Element outputLengthElement = (Element)children.get(0);
        String value = StringSupport.trimOrNull((String)outputLengthElement.getTextContent());
        Assert.assertNotNull((Object)value, (String)"Output length value was empty");
        Assert.assertEquals((Object)new Integer(value), (Object)this.hmacOutputLength, (String)"Output length was not the expected value");
    }

    private SignableSimpleXMLObject getXMLObjectWithSignature(boolean useHMACOutputLength) {
        SignableSimpleXMLObject sxo = this.sxoBuilder.buildObject();
        sxo.setId("FOO");
        SignatureImpl sig = this.sigBuilder.buildObject();
        sig.setSigningCredential(this.goodCredential);
        sig.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        sig.setSignatureAlgorithm(this.algoURI);
        if (useHMACOutputLength) {
            sig.setHMACOutputLength(this.hmacOutputLength);
        }
        DocumentInternalIDContentReference contentReference = new DocumentInternalIDContentReference("FOO");
        contentReference.getTransforms().add("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        contentReference.getTransforms().add("http://www.w3.org/2001/10/xml-exc-c14n#");
        contentReference.setDigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
        sig.getContentReferences().add(contentReference);
        KeyInfo keyInfo = this.keyInfoBuilder.buildObject();
        KeyInfoSupport.addKeyName((KeyInfo)keyInfo, (String)this.expectedKeyName);
        sig.setKeyInfo(keyInfo);
        sxo.setSignature((Signature)sig);
        return sxo;
    }
}

