/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.support;

import java.util.HashSet;
import java.util.Set;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.xmlsec.mock.SignableSimpleXMLObject;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.impl.SignatureAlgorithmValidator;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SignatureAlgorithmValidatorTest
extends XMLObjectBaseTestCase {
    private Signature signature;
    private final String targetSignatureMethod = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    private final String targetDigestMethod = "http://www.w3.org/2001/04/xmlenc#sha256";
    private Set<String> whitelist;
    private Set<String> blacklist;
    private SignatureAlgorithmValidator validator;

    @BeforeMethod
    public void setUp() {
        this.whitelist = new HashSet<String>();
        this.blacklist = new HashSet<String>();
        SignableSimpleXMLObject ssxo = (SignableSimpleXMLObject)this.unmarshallElement("/data/org/opensaml/xmlsec/signature/support/envelopedSignature.xml");
        this.signature = ssxo.getSignature();
    }

    @Test
    public void testEmptyLists() throws SignatureException {
        this.validator = new SignatureAlgorithmValidator(this.whitelist, this.blacklist);
        this.validator.validate(this.signature);
    }

    @Test
    public void testWhitelistedURIs() throws SignatureException {
        this.whitelist.add("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        this.whitelist.add("http://www.w3.org/2001/04/xmlenc#sha256");
        this.validator = new SignatureAlgorithmValidator(this.whitelist, this.blacklist);
        this.validator.validate(this.signature);
    }

    @Test(expectedExceptions={SignatureException.class})
    public void testBlacklistedSignatureMethod() throws SignatureException {
        this.blacklist.add("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        this.validator = new SignatureAlgorithmValidator(this.whitelist, this.blacklist);
        this.validator.validate(this.signature);
    }

    @Test(expectedExceptions={SignatureException.class})
    public void testBlacklistedBlacklistedMethod() throws SignatureException {
        this.blacklist.add("http://www.w3.org/2001/04/xmlenc#sha256");
        this.validator = new SignatureAlgorithmValidator(this.whitelist, this.blacklist);
        this.validator.validate(this.signature);
    }
}

