/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.mock.SimpleXMLObject;
import org.opensaml.xmlsec.encryption.EncryptionProperty;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EncryptionPropertyTest
extends XMLObjectProviderBaseTestCase {
    private String expectedTarget;
    private String expectedID;
    private int expectedNumUnknownChildren;
    private QName expectedAttribName1;
    private QName expectedAttribName2;
    private String expectedAttribValue1;
    private String expectedAttribValue2;

    public EncryptionPropertyTest() {
        this.singleElementFile = "/data/org/opensaml/xmlsec/encryption/impl/EncryptionProperty.xml";
        this.singleElementOptionalAttributesFile = "/data/org/opensaml/xmlsec/encryption/impl/EncryptionPropertyOptionalAttributes.xml";
        this.childElementsFile = "/data/org/opensaml/xmlsec/encryption/impl/EncryptionPropertyChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedTarget = "urn:string:foo";
        this.expectedID = "someID";
        this.expectedNumUnknownChildren = 2;
        this.expectedAttribName1 = new QName("urn:namespace:foo", "bar", "foo");
        this.expectedAttribValue1 = "abc";
        this.expectedAttribName2 = new QName("urn:namespace:foo", "baz", "foo");
        this.expectedAttribValue2 = "123";
    }

    @Test
    public void testSingleElementUnmarshall() {
        EncryptionProperty ep = (EncryptionProperty)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)ep, (String)"EncryptionProperty");
        Assert.assertNull((Object)ep.getTarget(), (String)"Target attribute");
        Assert.assertNull((Object)ep.getID(), (String)"Id attribute");
        Assert.assertEquals((int)ep.getUnknownXMLObjects().size(), (int)0, (String)"Unknown children");
        Assert.assertNull((Object)ep.getUnknownAttributes().get((Object)this.expectedAttribName1), (String)"Unknown attribute 1");
        Assert.assertNull((Object)ep.getUnknownAttributes().get((Object)this.expectedAttribName2), (String)"Unknown attribute 2");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        EncryptionProperty ep = (EncryptionProperty)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertNotNull((Object)ep, (String)"EncryptionProperty");
        Assert.assertEquals((String)ep.getTarget(), (String)this.expectedTarget, (String)"Target attribute");
        Assert.assertEquals((String)ep.getID(), (String)this.expectedID, (String)"Id attribute");
        Assert.assertEquals((int)ep.getUnknownXMLObjects().size(), (int)0, (String)"Unknown children");
        Assert.assertEquals((String)ep.getUnknownAttributes().get((Object)this.expectedAttribName1), (String)this.expectedAttribValue1, (String)"Unknown attribute 1");
        Assert.assertEquals((String)ep.getUnknownAttributes().get((Object)this.expectedAttribName2), (String)this.expectedAttribValue2, (String)"Unknown attribute 2");
        Assert.assertEquals((Object)ep.resolveID(this.expectedID), (Object)ep, (String)"ID lookup failed");
    }

    @Test
    public void testChildElementsUnmarshall() {
        EncryptionProperty ep = (EncryptionProperty)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)ep, (String)"EncryptionProperty");
        Assert.assertNull((Object)ep.getTarget(), (String)"Target attribute");
        Assert.assertNull((Object)ep.getID(), (String)"Id attribute");
        Assert.assertEquals((int)ep.getUnknownXMLObjects().size(), (int)this.expectedNumUnknownChildren, (String)"Unknown children");
    }

    @Test
    public void testSingleElementMarshall() {
        EncryptionProperty ep = (EncryptionProperty)this.buildXMLObject(EncryptionProperty.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)ep);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        EncryptionProperty ep = (EncryptionProperty)this.buildXMLObject(EncryptionProperty.DEFAULT_ELEMENT_NAME);
        ep.setTarget(this.expectedTarget);
        ep.setID(this.expectedID);
        ep.getUnknownAttributes().put(this.expectedAttribName1, this.expectedAttribValue1);
        ep.getUnknownAttributes().put(this.expectedAttribName2, this.expectedAttribValue2);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)ep);
    }

    @Test
    public void testChildElementsMarshall() {
        EncryptionProperty ep = (EncryptionProperty)this.buildXMLObject(EncryptionProperty.DEFAULT_ELEMENT_NAME);
        ep.getUnknownXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        ep.getUnknownXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)ep);
    }
}

