/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import java.util.Arrays;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.opensaml.xmlsec.impl.BlacklistPredicate;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BlacklistPredicateTest {
    @Test
    public void testBasic() {
        BlacklistPredicate predicate = new BlacklistPredicate(Arrays.asList("A", "B", "C", "D"));
        Assert.assertFalse((boolean)predicate.apply("A"));
        Assert.assertFalse((boolean)predicate.apply("B"));
        Assert.assertFalse((boolean)predicate.apply("C"));
        Assert.assertFalse((boolean)predicate.apply("D"));
        Assert.assertTrue((boolean)predicate.apply("X"));
        Assert.assertTrue((boolean)predicate.apply("Y"));
        Assert.assertTrue((boolean)predicate.apply("Z"));
        Assert.assertTrue((boolean)predicate.apply("foo"));
        Assert.assertTrue((boolean)predicate.apply("bar"));
        Assert.assertTrue((boolean)predicate.apply("bax"));
    }

    @Test
    public void testWithNullsInSet() {
        BlacklistPredicate predicate = new BlacklistPredicate(Arrays.asList("A", null, "B", null, "C", null, "D"));
        Assert.assertFalse((boolean)predicate.apply("A"));
        Assert.assertFalse((boolean)predicate.apply("B"));
        Assert.assertFalse((boolean)predicate.apply("C"));
        Assert.assertFalse((boolean)predicate.apply("D"));
        Assert.assertTrue((boolean)predicate.apply("X"));
        Assert.assertTrue((boolean)predicate.apply("Y"));
        Assert.assertTrue((boolean)predicate.apply("Z"));
        Assert.assertTrue((boolean)predicate.apply("foo"));
        Assert.assertTrue((boolean)predicate.apply("bar"));
        Assert.assertTrue((boolean)predicate.apply("bax"));
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullSet() {
        new BlacklistPredicate(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testNullArg() {
        BlacklistPredicate predicate = new BlacklistPredicate(Arrays.asList("A", "B", "C", "D"));
        predicate.apply(null);
    }
}

