/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import java.util.Arrays;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.opensaml.xmlsec.impl.WhitelistPredicate;
import org.testng.Assert;
import org.testng.annotations.Test;

public class WhitelistPredicateTest {
    @Test
    public void testBasic() {
        WhitelistPredicate predicate = new WhitelistPredicate(Arrays.asList("A", "B", "C", "D"));
        Assert.assertTrue((boolean)predicate.apply("A"));
        Assert.assertTrue((boolean)predicate.apply("B"));
        Assert.assertTrue((boolean)predicate.apply("C"));
        Assert.assertTrue((boolean)predicate.apply("D"));
        Assert.assertFalse((boolean)predicate.apply("X"));
        Assert.assertFalse((boolean)predicate.apply("Y"));
        Assert.assertFalse((boolean)predicate.apply("Z"));
        Assert.assertFalse((boolean)predicate.apply("foo"));
        Assert.assertFalse((boolean)predicate.apply("bar"));
        Assert.assertFalse((boolean)predicate.apply("bax"));
    }

    @Test
    public void testWithNullsInSet() {
        WhitelistPredicate predicate = new WhitelistPredicate(Arrays.asList("A", null, "B", null, "C", null, "D"));
        Assert.assertTrue((boolean)predicate.apply("A"));
        Assert.assertTrue((boolean)predicate.apply("B"));
        Assert.assertTrue((boolean)predicate.apply("C"));
        Assert.assertTrue((boolean)predicate.apply("D"));
        Assert.assertFalse((boolean)predicate.apply("X"));
        Assert.assertFalse((boolean)predicate.apply("Y"));
        Assert.assertFalse((boolean)predicate.apply("Z"));
        Assert.assertFalse((boolean)predicate.apply("foo"));
        Assert.assertFalse((boolean)predicate.apply("bar"));
        Assert.assertFalse((boolean)predicate.apply("bax"));
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullSet() {
        new WhitelistPredicate(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testNullArg() {
        WhitelistPredicate predicate = new WhitelistPredicate(Arrays.asList("A", "B", "C", "D"));
        predicate.apply(null);
    }
}

