/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xmlsec.signature.KeyInfoReference;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;

public class KeyInfoReferenceTest
extends XMLObjectProviderBaseTestCase {
    private String expectedID;
    private String expectedURI;

    public KeyInfoReferenceTest() {
        this.singleElementFile = "/data/org/opensaml/xmlsec/signature/impl/KeyInfoReference.xml";
        this.singleElementOptionalAttributesFile = "/data/org/opensaml/xmlsec/signature/impl/KeyInfoReferenceOptionalAttributes.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedID = "bar";
        this.expectedURI = "#foo";
    }

    public void testSingleElementUnmarshall() {
        KeyInfoReference ref = (KeyInfoReference)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)ref, (String)"KeyInfoReference");
        Assert.assertEquals((String)ref.getURI(), (String)this.expectedURI, (String)"URI attribute");
    }

    public void testSingleElementOptionalAttributesUnmarshall() {
        KeyInfoReference ref = (KeyInfoReference)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertNotNull((Object)ref, (String)"KeyInfoReference");
        Assert.assertEquals((String)ref.getID(), (String)this.expectedID, (String)"Id attribute");
        Assert.assertEquals((String)ref.getURI(), (String)this.expectedURI, (String)"URI attribute");
        Assert.assertEquals((Object)ref.resolveIDFromRoot(this.expectedID), (Object)ref);
    }

    public void testSingleElementMarshall() {
        KeyInfoReference ref = (KeyInfoReference)this.buildXMLObject(KeyInfoReference.DEFAULT_ELEMENT_NAME);
        ref.setURI(this.expectedURI);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)ref);
    }

    public void testSingleElementOptionalAttributesMarshall() {
        KeyInfoReference ref = (KeyInfoReference)this.buildXMLObject(KeyInfoReference.DEFAULT_ELEMENT_NAME);
        ref.setID(this.expectedID);
        ref.setURI(this.expectedURI);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)ref);
        Assert.assertEquals((Object)ref.resolveIDFromRoot(this.expectedID), (Object)ref);
    }
}

