/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xmlsec.encryption.CipherReference;
import org.opensaml.xmlsec.encryption.Transforms;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CipherReferenceTest
extends XMLObjectProviderBaseTestCase {
    private String expectedURI;

    public CipherReferenceTest() {
        this.singleElementFile = "/data/org/opensaml/xmlsec/encryption/impl/CipherReference.xml";
        this.childElementsFile = "/data/org/opensaml/xmlsec/encryption/impl/CipherReferenceChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedURI = "urn:string:foo";
    }

    @Test
    public void testSingleElementUnmarshall() {
        CipherReference cr = (CipherReference)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)cr, (String)"CipherReference");
        Assert.assertEquals((String)cr.getURI(), (String)this.expectedURI, (String)"URI attribute");
        Assert.assertNull((Object)cr.getTransforms(), (String)"Transforms child");
    }

    @Test
    public void testChildElementsUnmarshall() {
        CipherReference cr = (CipherReference)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)cr, (String)"CipherReference");
        Assert.assertEquals((String)cr.getURI(), (String)this.expectedURI, (String)"URI attribute");
        Assert.assertNotNull((Object)cr.getTransforms(), (String)"Transforms child");
    }

    @Test
    public void testSingleElementMarshall() {
        CipherReference cr = (CipherReference)this.buildXMLObject(CipherReference.DEFAULT_ELEMENT_NAME);
        cr.setURI(this.expectedURI);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)cr);
    }

    @Test
    public void testChildElementsMarshall() {
        CipherReference cr = (CipherReference)this.buildXMLObject(CipherReference.DEFAULT_ELEMENT_NAME);
        cr.setURI(this.expectedURI);
        cr.setTransforms((Transforms)this.buildXMLObject(Transforms.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)cr);
    }
}

