/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xmlsec.encryption.CipherData;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.EncryptionMethod;
import org.opensaml.xmlsec.encryption.EncryptionProperties;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EncryptedDataTest
extends XMLObjectProviderBaseTestCase {
    private String expectedId;
    private String expectedType;
    private String expectedMimeType;
    private String expectedEncoding;

    public EncryptedDataTest() {
        this.singleElementFile = "/data/org/opensaml/xmlsec/encryption/impl/EncryptedData.xml";
        this.singleElementOptionalAttributesFile = "/data/org/opensaml/xmlsec/encryption/impl/EncryptedDataOptionalAttributes.xml";
        this.childElementsFile = "/data/org/opensaml/xmlsec/encryption/impl/EncryptedDataChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedId = "abc123";
        this.expectedType = "someType";
        this.expectedMimeType = "someMimeType";
        this.expectedEncoding = "someEncoding";
    }

    @Test
    public void testSingleElementUnmarshall() {
        EncryptedData ed = (EncryptedData)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)ed, (String)"EncryptedData");
        Assert.assertNull((Object)ed.getEncryptionMethod(), (String)"EncryptionMethod child");
        Assert.assertNull((Object)ed.getKeyInfo(), (String)"KeyInfo child");
        Assert.assertNull((Object)ed.getCipherData(), (String)"CipherData child");
        Assert.assertNull((Object)ed.getEncryptionProperties(), (String)"EncryptionProperties child");
    }

    @Test
    public void testChildElementsUnmarshall() {
        EncryptedData ed = (EncryptedData)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)ed, (String)"EncryptedData");
        Assert.assertNotNull((Object)ed.getEncryptionMethod(), (String)"EncryptionMethod child");
        Assert.assertNotNull((Object)ed.getKeyInfo(), (String)"KeyInfo child");
        Assert.assertNotNull((Object)ed.getCipherData(), (String)"CipherData child");
        Assert.assertNotNull((Object)ed.getEncryptionProperties(), (String)"EncryptionProperties child");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        EncryptedData ed = (EncryptedData)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertNotNull((Object)ed, (String)"EncryptedData");
        Assert.assertEquals((String)ed.getID(), (String)this.expectedId, (String)"Id attribute");
        Assert.assertEquals((String)ed.getType(), (String)this.expectedType, (String)"Type attribute");
        Assert.assertEquals((String)ed.getMimeType(), (String)this.expectedMimeType, (String)"MimeType attribute");
        Assert.assertEquals((String)ed.getEncoding(), (String)this.expectedEncoding, (String)"Encoding attribute");
        Assert.assertEquals((Object)ed.resolveID(this.expectedId), (Object)ed, (String)"ID lookup failed");
    }

    @Test
    public void testSingleElementMarshall() {
        EncryptedData ed = (EncryptedData)this.buildXMLObject(EncryptedData.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)ed);
    }

    @Test
    public void testChildElementsMarshall() {
        EncryptedData ed = (EncryptedData)this.buildXMLObject(EncryptedData.DEFAULT_ELEMENT_NAME);
        ed.setEncryptionMethod((EncryptionMethod)this.buildXMLObject(EncryptionMethod.DEFAULT_ELEMENT_NAME));
        ed.setKeyInfo((KeyInfo)this.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME));
        ed.setCipherData((CipherData)this.buildXMLObject(CipherData.DEFAULT_ELEMENT_NAME));
        ed.setEncryptionProperties((EncryptionProperties)this.buildXMLObject(EncryptionProperties.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)ed);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        EncryptedData ed = (EncryptedData)this.buildXMLObject(EncryptedData.DEFAULT_ELEMENT_NAME);
        ed.setID(this.expectedId);
        ed.setType(this.expectedType);
        ed.setMimeType(this.expectedMimeType);
        ed.setEncoding(this.expectedEncoding);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)ed);
    }
}

