/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.support;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.support.DataEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.Decrypter;
import org.opensaml.xmlsec.encryption.support.Encrypter;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.mock.SignableSimpleXMLObject;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EncryptionClonedContentTest
extends XMLObjectBaseTestCase {
    private String targetFile = "/data/org/opensaml/xmlsec/encryption/support/SimpleEncryptionTest.xml";
    private String algoURI = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";

    @Test
    public void testEncryptDecrypt() throws Exception {
        SignableSimpleXMLObject origXMLObject = (SignableSimpleXMLObject)this.unmarshallElement(this.targetFile);
        SignableSimpleXMLObject clonedXMLObject = (SignableSimpleXMLObject)XMLObjectSupport.cloneXMLObject((XMLObject)origXMLObject);
        Credential encCred = AlgorithmSupport.generateSymmetricKeyAndCredential((String)this.algoURI);
        DataEncryptionParameters encParams = new DataEncryptionParameters();
        encParams.setAlgorithm(this.algoURI);
        encParams.setEncryptionCredential(encCred);
        Encrypter encrypter = new Encrypter();
        EncryptedData encryptedData = encrypter.encryptElement((XMLObject)clonedXMLObject, encParams);
        Assert.assertNotNull((Object)encryptedData);
        Assert.assertEquals((String)encryptedData.getEncryptionMethod().getAlgorithm(), (String)this.algoURI);
        StaticKeyInfoCredentialResolver dataKeyInfoResolver = new StaticKeyInfoCredentialResolver(encCred);
        Decrypter decrypter = new Decrypter((KeyInfoCredentialResolver)dataKeyInfoResolver, null, null);
        XMLObject decryptedXMLObject = decrypter.decryptData(encryptedData);
        Assert.assertNotNull((Object)decryptedXMLObject);
        Assert.assertTrue((boolean)(decryptedXMLObject instanceof SignableSimpleXMLObject));
        this.assertXMLEquals(origXMLObject.getDOM().getOwnerDocument(), decryptedXMLObject);
    }
}

