/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.keyinfo.impl;

import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.ChainingKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ChainingKeyInfoCredentialResolverTest
extends XMLObjectBaseTestCase {
    private ChainingKeyInfoCredentialResolver chainingResolver;
    private CriteriaSet criteriaSet;
    private KeyInfoCredentialResolver staticResolver12;
    private KeyInfoCredentialResolver staticResolver3;
    private KeyInfoCredentialResolver staticResolver45;
    private KeyInfoCredentialResolver staticResolverEmpty;
    private Credential cred1;
    private Credential cred2;
    private Credential cred3;
    private Credential cred4;
    private Credential cred5;

    @BeforeClass
    protected void buildCredsAndResolvers() throws Exception {
        KeyPair kp = KeySupport.generateKeyPair((String)"RSA", (int)1024, null);
        this.cred1 = new BasicCredential(kp.getPublic(), kp.getPrivate());
        kp = KeySupport.generateKeyPair((String)"RSA", (int)1024, null);
        this.cred2 = new BasicCredential(kp.getPublic(), kp.getPrivate());
        kp = KeySupport.generateKeyPair((String)"RSA", (int)1024, null);
        this.cred3 = new BasicCredential(kp.getPublic(), kp.getPrivate());
        kp = KeySupport.generateKeyPair((String)"RSA", (int)1024, null);
        this.cred4 = new BasicCredential(kp.getPublic(), kp.getPrivate());
        kp = KeySupport.generateKeyPair((String)"RSA", (int)1024, null);
        this.cred5 = new BasicCredential(kp.getPublic(), kp.getPrivate());
        this.criteriaSet = new CriteriaSet();
        ArrayList<Credential> temp = new ArrayList<Credential>();
        temp.add(this.cred1);
        temp.add(this.cred2);
        this.staticResolver12 = new StaticKeyInfoCredentialResolver(temp);
        temp = new ArrayList();
        temp.add(this.cred3);
        this.staticResolver3 = new StaticKeyInfoCredentialResolver(temp);
        temp = new ArrayList();
        temp.add(this.cred4);
        temp.add(this.cred5);
        this.staticResolver45 = new StaticKeyInfoCredentialResolver(temp);
        temp = new ArrayList();
        this.staticResolverEmpty = new StaticKeyInfoCredentialResolver(temp);
    }

    @Test
    public void testOneEmptyMember() throws ResolverException {
        this.chainingResolver = new ChainingKeyInfoCredentialResolver(Collections.singletonList(this.staticResolverEmpty));
        List<Credential> resolved = this.getResolved(this.chainingResolver.resolve(this.criteriaSet));
        this.checkResolved(resolved, 0, new Credential[0]);
    }

    @Test
    public void testMultipleEmptyMember() throws ResolverException {
        this.chainingResolver = new ChainingKeyInfoCredentialResolver(Arrays.asList(this.staticResolverEmpty, this.staticResolverEmpty, this.staticResolverEmpty));
        List<Credential> resolved = this.getResolved(this.chainingResolver.resolve(this.criteriaSet));
        this.checkResolved(resolved, 0, new Credential[0]);
    }

    @Test
    public void testOneMember() throws ResolverException {
        this.chainingResolver = new ChainingKeyInfoCredentialResolver(Collections.singletonList(this.staticResolver12));
        List<Credential> resolved = this.getResolved(this.chainingResolver.resolve(this.criteriaSet));
        this.checkResolved(resolved, 2, this.cred1, this.cred2);
    }

    @Test
    public void testMultipleMembers() throws ResolverException {
        this.chainingResolver = new ChainingKeyInfoCredentialResolver(Arrays.asList(this.staticResolver12, this.staticResolver3, this.staticResolverEmpty, this.staticResolver45));
        List<Credential> resolved = this.getResolved(this.chainingResolver.resolve(this.criteriaSet));
        this.checkResolved(resolved, 5, this.cred1, this.cred2, this.cred3, this.cred4, this.cred5);
    }

    @Test
    public void testOrderingMultipleMembers() throws ResolverException {
        this.chainingResolver = new ChainingKeyInfoCredentialResolver(Arrays.asList(this.staticResolverEmpty, this.staticResolver45, this.staticResolverEmpty, this.staticResolver3, this.staticResolver12));
        List<Credential> resolved = this.getResolved(this.chainingResolver.resolve(this.criteriaSet));
        this.checkResolved(resolved, 5, this.cred1, this.cred2, this.cred3, this.cred4, this.cred5);
        Assert.assertEquals((Object)resolved.get(0), (Object)this.cred4, (String)"Credential found out-of-order");
        Assert.assertEquals((Object)resolved.get(1), (Object)this.cred5, (String)"Credential found out-of-order");
        Assert.assertEquals((Object)resolved.get(2), (Object)this.cred3, (String)"Credential found out-of-order");
        Assert.assertEquals((Object)resolved.get(3), (Object)this.cred1, (String)"Credential found out-of-order");
        Assert.assertEquals((Object)resolved.get(4), (Object)this.cred2, (String)"Credential found out-of-order");
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testEmptyResolverChain() throws ResolverException {
        this.chainingResolver = new ChainingKeyInfoCredentialResolver(new ArrayList());
        this.chainingResolver.resolve(this.criteriaSet);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testRemove() throws ResolverException {
        this.chainingResolver = new ChainingKeyInfoCredentialResolver(Collections.singletonList(this.staticResolver12));
        Iterator iter = this.chainingResolver.resolve(this.criteriaSet).iterator();
        Assert.assertTrue((boolean)iter.hasNext(), (String)"Iterator was empty");
        iter.next();
        iter.remove();
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testNoMoreMembers() throws ResolverException {
        this.chainingResolver = new ChainingKeyInfoCredentialResolver(Arrays.asList(this.staticResolver12, this.staticResolver3));
        Iterator iter = this.chainingResolver.resolve(this.criteriaSet).iterator();
        Assert.assertTrue((boolean)iter.hasNext(), (String)"Should have next member");
        iter.next();
        Assert.assertTrue((boolean)iter.hasNext(), (String)"Should have next member");
        iter.next();
        Assert.assertTrue((boolean)iter.hasNext(), (String)"Should have next member");
        iter.next();
        Assert.assertFalse((boolean)iter.hasNext(), (String)"Should NOT have next member");
        iter.next();
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testChainUnmodifiable() {
        this.chainingResolver = new ChainingKeyInfoCredentialResolver(Collections.singletonList(this.staticResolver12));
        this.chainingResolver.getResolverChain().add(this.staticResolver3);
    }

    private List<Credential> getResolved(Iterable<Credential> iter) {
        ArrayList<Credential> resolved = new ArrayList<Credential>();
        for (Credential cred : iter) {
            resolved.add(cred);
        }
        return resolved;
    }

    private void checkResolved(List<Credential> resolved, int expectedNum, Credential ... expectedCreds) {
        Assert.assertEquals((int)resolved.size(), (int)expectedNum, (String)"Unexpected number of matches");
        for (Credential expectedCred : expectedCreds) {
            Assert.assertTrue((boolean)resolved.contains(expectedCred), (String)("Expected member not found: " + expectedCred));
        }
    }
}

